/** 
 * TimerStack a stack that holds methodtimes.
 */
#ifndef TIMERSTACK_H__
#define TIMERSTACK_H__

#include <jmp.h>
#include <method.h>
#include <methodtime.h>

typedef struct stack_node stack_node;

struct stack_node {
    method*     method;
    long        calls;
    methodtime  time_taken;    
    stack_node* parent;
    stack_node* siebling;
    stack_node* first_child;
};

struct timerstack {
    methodtime*      times;
    stack_node*      stack_node;
    size_t           top;
    size_t           max;
    jlong            last_contentation;
    jlong            cpu_time;     /** Last result of get_thread_time. */
    jlong            contendtime;  /** The time this thread has spend waiting for locks.. */
    obj*             waiting;      /** The object this thread is waiting on. */
    jlong            timeout;      /** wait timeout. */
    JVMPI_RawMonitor monitor;      /** The monitor for multi threaded access. */    
};

/** Create a new stack with a minimun size of size. 
 *  This stack will be expanded as needed.
 */
timerstack* timerstack_new (size_t size);

/** Delete the given stack. */
void timerstack_free (timerstack* s);

/** Expand the given stack. */
void timerstack_expand (timerstack* s);

/** Set the need to lock flag. */
void timerstacks_set_need_locks (int i);

/** Lock a given timerstack */
void timerstack_lock (timerstack *s);

/** Unlock a given timerstack */
void timerstack_unlock (timerstack *s);

#endif /* TIMERSTACK_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
