#ifndef METHODTIME_H__
#define METHODTIME_H__

#include <jmp.h>

/** This is a placeholder for the time taken by a method.
 */
struct methodtime {
    jlong tv;                /* time (nanos) taken by this method */
    jlong tv_hold;           /* time taken by called methods. */
    method* method;	     /* The ptr of the method running. */
    method* filtered_method; /* The current filtered method. */
};

/** Check if a methodtime is zero 
 * @param mt the methodtime to check.
 * @return true if all time values of mt is zero.
 */
int methodtime_is_zero (methodtime* mt);

#endif /* METHODTIME_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
