/*
 * Decompiled with CFR 0.152.
 */
package com.mentorgen.tools.profile.output;

import com.mentorgen.tools.profile.Controller;
import com.mentorgen.tools.profile.runtime.ClassAllocation;
import com.mentorgen.tools.profile.runtime.Frame;
import com.mentorgen.tools.profile.runtime.Profile;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

final class ProfileXMLDump {
    private static HashMap<String, String> _classNameMap = new HashMap();
    private static String _fileName;
    private static String _date;

    ProfileXMLDump() {
    }

    static void dump() throws IOException {
        ProfileXMLDump.createFileName();
        FileWriter fileWriter = new FileWriter(_fileName);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        ProfileXMLDump.outputHeader(printWriter);
        ProfileXMLDump.outputCallGraph(printWriter);
        ProfileXMLDump.outputObjectAlloc(printWriter);
        ProfileXMLDump.outputClassMap(printWriter);
        ProfileXMLDump.outputEnd(printWriter);
        printWriter.flush();
        fileWriter.close();
    }

    private static void createFileName() {
        File file = new File(Controller._fileName);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
        _date = simpleDateFormat.format(new Date());
        if (file.isDirectory()) {
            StringBuffer stringBuffer = new StringBuffer(file.getAbsolutePath());
            stringBuffer.append(File.separator);
            stringBuffer.append(_date);
            stringBuffer.append(".xml");
            _fileName = stringBuffer.toString();
        } else {
            String string = Controller._fileName.trim();
            if (string.endsWith(".txt")) {
                String string2 = string;
                string2 = string2.substring(0, string2.length() - 4);
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.append(".xml");
                _fileName = stringBuffer.toString();
            } else if (string.endsWith(".xml")) {
                _fileName = string;
            } else {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append(".xml");
                _fileName = stringBuffer.toString();
            }
        }
    }

    private static void outputHeader(PrintWriter printWriter) throws IOException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ProfileXMLDump.startElement(printWriter, "profile", 0);
        ProfileXMLDump.attribute(printWriter, "file", _fileName);
        ProfileXMLDump.attribute(printWriter, "date", _date);
        ProfileXMLDump.cap(printWriter);
    }

    private static void outputCallGraph(PrintWriter printWriter) throws IOException {
        for (Long l : Profile.threads()) {
            ProfileXMLDump.startElement(printWriter, "thread", 1);
            ProfileXMLDump.attribute(printWriter, "id", l);
            ProfileXMLDump.cap(printWriter);
            int n = 1;
            for (Frame frame : Profile.interactions(l)) {
                ProfileXMLDump.startElement(printWriter, "interaction", 2);
                ProfileXMLDump.attribute(printWriter, "id", n++);
                ProfileXMLDump.cap(printWriter);
                ProfileXMLDump.outputFrame(printWriter, frame, 3);
                ProfileXMLDump.endElement(printWriter, "interaction", 2);
            }
            ProfileXMLDump.endElement(printWriter, "thread", 1);
        }
    }

    private static void outputFrame(PrintWriter printWriter, Frame frame, int n) throws IOException {
        ProfileXMLDump.startElement(printWriter, "frame", n);
        ProfileXMLDump.attribute(printWriter, "cn", ProfileXMLDump.shortenClassName(frame.getClassName()));
        ProfileXMLDump.attribute(printWriter, "mn", frame.getName());
        ProfileXMLDump.attribute(printWriter, "c", frame._metrics.getCount());
        ProfileXMLDump.attribute(printWriter, "t", frame._metrics.getTotalTime());
        if (!frame.hasChildren()) {
            ProfileXMLDump.endElement(printWriter);
            return;
        }
        ProfileXMLDump.cap(printWriter);
        for (Frame frame2 : frame.childIterator()) {
            ProfileXMLDump.outputFrame(printWriter, frame2, n + 1);
        }
        ProfileXMLDump.endElement(printWriter, "frame", n);
    }

    private static void outputObjectAlloc(PrintWriter printWriter) throws IOException {
        ProfileXMLDump.startElement(printWriter, "allocation", 1);
        ProfileXMLDump.cap(printWriter);
        for (ClassAllocation classAllocation : Profile.allocations()) {
            ProfileXMLDump.startElement(printWriter, "class", 2);
            ProfileXMLDump.attribute(printWriter, "cn", ProfileXMLDump.shortenClassName(classAllocation.getInternalClassName()));
            ProfileXMLDump.attribute(printWriter, "c", classAllocation.getAllocCount());
            ProfileXMLDump.endElement(printWriter);
        }
        ProfileXMLDump.endElement(printWriter, "allocation", 1);
    }

    private static void outputClassMap(PrintWriter printWriter) throws IOException {
        ProfileXMLDump.startElement(printWriter, "class-map", 1);
        ProfileXMLDump.cap(printWriter);
        for (String string : _classNameMap.keySet()) {
            String string2 = _classNameMap.get(string);
            ProfileXMLDump.startElement(printWriter, "entry", 2);
            ProfileXMLDump.attribute(printWriter, "s", string);
            ProfileXMLDump.attribute(printWriter, "f", string2);
            ProfileXMLDump.endElement(printWriter);
        }
        ProfileXMLDump.endElement(printWriter, "class-map", 1);
    }

    private static void outputEnd(PrintWriter printWriter) throws IOException {
        ProfileXMLDump.endElement(printWriter, "profile", 0);
    }

    private static void startElement(PrintWriter printWriter, String string, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            printWriter.print('\t');
        }
        printWriter.print("<");
        printWriter.print(string);
    }

    private static void cap(PrintWriter printWriter) {
        printWriter.println(">");
    }

    private static void endElement(PrintWriter printWriter) {
        printWriter.println("/>");
    }

    private static void endElement(PrintWriter printWriter, String string, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            printWriter.print('\t');
        }
        printWriter.print("</");
        printWriter.print(string);
        printWriter.println(">");
    }

    private static void attribute(PrintWriter printWriter, String string, Object object) throws IOException {
        char[] cArray;
        printWriter.print(" ");
        printWriter.print(string);
        printWriter.print("=\"");
        for (char c : cArray = object.toString().toCharArray()) {
            if (c == '<') {
                printWriter.print("&lt;");
                continue;
            }
            if (c == '>') {
                printWriter.print("&gt;");
                continue;
            }
            printWriter.print(c);
        }
        printWriter.print("\"");
    }

    private static String shortenClassName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] == '/') {
                String string2 = _classNameMap.get(stringBuffer.toString());
                if (string2 == null) {
                    _classNameMap.put(stringBuffer.toString(), string);
                    return stringBuffer.toString();
                }
                if (string2.equals(string)) {
                    return stringBuffer.toString();
                }
            }
            stringBuffer.insert(0, cArray[i]);
        }
        return string;
    }
}

