#!/bin/sh
# DVB mpeg file import script for kmediafactory

# Specify path of the ProjecytX.jat here if it is not found automatically
JAR=""

# For debugging
#KMF_DCOP=kmediafactory-26450
#KMF_WINID=0

fatal()
{
	echo "$1"
	kdialog --error "$1"
	exit 1
}

PROJECT_DIR=`dcop $KMF_DCOP KMediaFactoryIface projectDirectory media`

if [ "$PROJECT_DIR" == "" ]; then
	fatal "Can't connect to KMediaFactory."
fi

PROJECTX=`which projectx`
if [ "$?" -ne 0 ]; then
  if [ "$JAR" == "" ]; then
    LOCATE=`which locate`
    if [ "$?" -eq 0 ]; then
      JAR=`$LOCATE 'ProjectX.jar'`
    fi
  fi
  if [ "$JAR" != "" ]; then
    PROJECTX="java -jar $JAR"
  fi
fi
  
if [ "$PROJECTX" == "" ]; then
  fatal "Can't find ProjectX application.
         http://sourceforge.net/projects/project-x"
fi

FILE=`kdialog --title "Add DVB file" \
	--getopenfilename ":KMF_DVB" "*.ts *.ps *.mpg *.mpeg|Mpeg files" \
	--embed $KMF_WINID`

if [ "$FILE" != "" ]; then
	$PROJECTX -gui "$FILE" -out "$PROJECT_DIR"
	BASE=`basename "$FILE"`
  INPUT_AUDIO_AC3="${PROJECT_DIR}/${BASE%.*}.ac3"
	INPUT_AUDIO_MP2="${PROJECT_DIR}/${BASE%.*}.mp2"
	INPUT_VIDEO="${PROJECT_DIR}/${BASE%.*}.m2v"
	OUTPUT="${PROJECT_DIR}/${BASE%.*}.mpg"
	kdialog --title "Converting..." \
		--passivepopup "This may take a long time. File: $OUTPUT"  \
		--embed $KMF_WINID&
	NOTE=$!
	if [ -e "$INPUT_AUDIO_AC3" ]; then
    INPUT_AUDIO=$INPUT_AUDIO_AC3
  elif [ -e "$INPUT_AUDIO_MP2" ]; then
    INPUT_AUDIO=$INPUT_AUDIO_MP2
  else
		fatal "Audio file $INPUT_AUDIO not found."
	fi
	if [ ! -e "$INPUT_VIDEO" ]; then
		fatal "Video file $INPUT_VIDEO not found."
	fi
	mplex -f 8 -o "$OUTPUT" "$INPUT_VIDEO" "$INPUT_AUDIO"
	RES=$?
	kill $NOTE
	if [ "$RES" -ne 0 ]; then
		fatal "Conversion failed."
	fi
	dcop $KMF_DCOP KMediaFactoryIface addMediaObject \
		"<media plugin=\"KMFImportVideo\" object=\"video\" >
		 <video><file path=\"$OUTPUT\" /></video></media>"
fi

