#!/bin/sh
# Add symbolic link in ffmpeg cvs tree: x86_64 -> i386

CVS="/usr/src/ffmpeg"
HOME=`echo ~`
DEST="$HOME/files/code/linux/kmediafactory/ffmpeg"

DIRS=(
  "libavcodec"
  "libavcodec/x86_64"
  "libavformat"
  "libavutil"
)

function update_cvs()
{
  echo -n "Update cvs (y/N): "
  read ans
  if [ "$ans" == y -o "$ans" == Y ]
  then
    cd $CVS
    cvs up -Pd
  fi
}

function check_new_files()
{
  for DIR in "${DIRS[@]}"; do
    echo "---------- $DIR ----------"
    cd "$CVS/$DIR"
    for file in $1; do
      if [ ! -e "$DEST/$DIR/$file" ]; then
        echo $file
        cp $CVS/$DIR/$file $DEST/$DIR/$file
      fi
    done
  done
}

function check_removed_files()
{
  for DIR in "${DIRS[@]}"; do
    echo "---------- $DIR ----------"
    cd "$DEST/$DIR"
    for file in $1; do
      if [ ! -e "$CVS/$DIR/$file" ]; then
        echo $file
        rm $DEST/$DIR/$file
      fi
    done
  done
}

function check_modified_files()
{
  for DIR in "${DIRS[@]}"; do
    echo "---------- $DIR ----------"
    cd "$CVS/$DIR"
    for file in $1; do
      if [ -e "$DEST/$DIR/$file" ]; then
        DIFF=`diff $file "$DEST/$DIR/$file"`
        if [ "$DIFF" != "" ]; then
          echo $file
          cp $CVS/$DIR/$file $DEST/$DIR/$file
        fi
      fi
    done
  done
}

update_cvs

echo "********** Modified files **********"
check_modified_files "*.h *.c"
echo "********** REMOVED FILES **********"
check_removed_files "*.h *.c"
echo "********** New files **********"
check_new_files "*.h *.c"
