/***************************************************************************
                          configuration.h  -  description
                             -------------------
    begin                : Thu Mar 28 2002
    copyright            : (C) 2002 by Sebastian Schildt
    email                : sebastian@frozenlight.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <qstring.h>
#include <qstringlist.h>
#include <qfont.h>

#include <ksimpleconfig.h>

#include "ksetiwatchimporter.h"


/**
  *@author Sebastian Schildt
  *
  * This class encapsulates the whole configuration including
  * reading & writing the configfile
  */

class configuration {
public: 
	configuration();
	~configuration();
	void readConfig();
	void saveConfig();

	bool isParsekswconfig() const;
	bool isPlayaudio() const;
	bool isStartclient() const;
	bool isManualTransfer() const;

	bool isOverrideSmall() const;
	bool isOverrideBig() const;
	bool isOverrideHead() const;

	QFont getSmallF() const;
	QFont getBigF() const;
	QFont getHeadF() const;

	int getManX() const;
	int getManY() const;
	bool isManualPositioning() const;

	QString getSetipath() const;
	QString getDatapath() const; //If .sah are not in the same dir with the client

	QStringList getSahdirs() const;
	
	void setParsekswconfig(bool val);
	void setPlayaudio(bool val);
	void setStartclient(bool val);
	void setManualTransfer(bool val);

	void setOverrideSmall(bool val);
	void setOverrideBig  (bool val);
	void setOverrideHead (bool val);
	void setSmallF(QFont tf);
	void setBigF  (QFont tf);
	void setHeadF (QFont tf);
	void setManualCoors(int x, int y);
	void setManualPositioning(bool val);

	void setSetipath(QString nsp);
	void setDatapath(QString ndp);

private:
	bool startclient, manualtransfer, playaudio, parsekswconfig;

	bool overrideSmall, overrideBig, overrideHead;
	QFont smallF, bigF, headF;

	bool manualPositioning;
	int manX, manY;

  QString setipath;
	QString datapath;
	QStringList sahdirs;
	
	KSetiwatchImporter kswI;

};

#endif
