/*
 * GXMame
 *
 * Copyright 2002-2004 Stephane Pontier <shadow_walker@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __GXMAME_H__
#define __GXMAME_H__

#include <kurl.h>

#include "common.h"

typedef struct {
	unsigned int red;
	unsigned int blue;
	unsigned int green;
} GdkColor ;

#include "gtkjoy.h"
#include "xmame_executable.h"
#include "game_list.h"

#define SELECT_TIMEOUT 110
#define ICON_TIMEOUT 100
#define SEARCH_TIMEOUT 1000

#define EXECUTABLE 1
#define GAMELIST 2

#define BUTTON_WIDTH 90

typedef enum {
	GAMENAME,
	HAS_ROMS,
	HAS_SAMPLES,
	ROMNAME,
	VECTOR,
	CONTROL,
	TIMESPLAYED,
	MANU,
	YEAR,
	CLONE,
	DRIVER,
	STATUS,       /*  Available / Not Available */
	ROMOF,
	DRIVERSTATUS, /*  Working / Not Working */
	NUMPLAYERS,
	NUMBUTTONS,
	CPU1,
	CPU2,
	CPU3,
	CPU4,
	SOUND1,
	SOUND2,
	SOUND3,
	SOUND4,
	MAMEVER,
	CATEGORY,
	FAVORITE,
	CHANNELS,
	NUMBER_COLUMN
} Columns_type;

/* Those are also columns. The only difference is that they are hidden */
typedef enum {
	ROMENTRY = NUMBER_COLUMN,
	TEXTCOLOR,
	PIXBUF,
	NUMBER_COLUMN_TOTAL
} Columns_type_hidden;

typedef enum  {
	SNAPSHOTS,
	FLYERS,
	CABINETS,
	MARQUEES,
	TITLES
} screenshot_type;

typedef enum  {
	NULL_FOLDER_ID,	/* 0	just for the folderID compliance*/
	ALL,		/* 1 */
	AVAILABLE,	/* 2 */
	UNAVAILABLE,	/* 3 */
	NEOGEO,		/* 4 */
	CPS1,		/* 18 */
	CPS2,		/* 19 */
	MANUFACTURERS, 	/* 5 just for the folderID compliance*/
	YEARS, 		/* 6 just for the folderID compliance*/
	WORKING,	/* 7 */
	NONWORKING,	/* 8 */
	CUSTOMS, 	/* 9 just for the folderID compliance*/
	PLAYED,		/* 10 */
	FAVORITES,	/* 11 */
	ORIGINALS,	/* 12 */
	CLONES,		/* 13 */
	RASTERS,	/* 14 */
	VECTORS,	/* 15 */
	TRACKBALL,	/* 16 */
	STEREO,
	DRIVERS,
	CATEGORIES,
	VERSIONS,
	SYSTEMS,
	NUMBER_FOLDER
} folder_filters_list;

typedef enum {
	LIST,
	LIST_TREE,
	DETAILS,
	DETAILS_TREE
} ListMode;

struct gui_prefs_struct {
	//RomEntry *current_game;
	gchar *currentMess, *currentMame;
	/* 1:All, 2:available, 3=unavailable, 4=NeoGeo, 5:Manufacturers
	   6=Years, 7=Working, 8=NonWorking, 9=Custom, 10=Played, 11=Favorites
	   12=originals, 13=clones 14=Raster, 15=Vector, 16=Trackball, 17=Stereo
	   18=CPS1, 19=CPS2
	   Mame32K			| GXMame
	   20=Namco 21=hack...		| 22=3D Games
	   got the year in good order, just need to find the good ofsset given by the number of manufacturer
	   240=year>1980 		| 293=year>1980
	   ...				| ...
	   248=<U>			| 301=<U>
	   249=1986			| 302=1986
	   ...				| ...
	   266=2000			| 319=2000
	  will be able to stick with mame32k only with first folders or
	  I have to assign a folder ID to all manufacturer and year at
	  the condition that I got the same manufacturers list.*/
	folder_filters_list FolderID;
	/*Show screenshot panel*/
	bool ShowScreenShot;
	/* 0:Snaps, 1:Flyers, 2:Cabinets, 3:Marquees, 4:Titles?*/
	bool ShowScreenShotTab;
	screenshot_type ShowFlyer;
	gint ShowToolBar;
	bool ShowStatusBar;
	bool ShowFolderList;
	bool GameCheck;
	bool VersionCheck;
/*	gint MMXCheck;*/
	bool ModifyThe;
/*	gint UseFavoriteNetPlay;*/
/*	gint UseIMEInChat;*/
/*	gint ChatDrawMode;*/
	gint SortColumn;
	bool SortReverse;
	/* Link table between absolute column Id and displayed column number */
	gint ColumnShownId[NUMBER_COLUMN];
	gint ColumnHiddenId[NUMBER_COLUMN];  /* Only needed on column_layout */
	gint GUIPosX;
	gint GUIPosY;
	gint GUIWidth;
	gint GUIHeight;
/*set by local
	gchar *Language;*/
	ListMode current_mode;
	ListMode previous_mode;

	gint Splitters[2];
	gchar *ListFont;
#ifndef KXMAME
	GdkFont *ListFontStruct;
#endif
	guint ListFontHeight;
	/* Width of each column ex: width of "game name" column is ColumnWidth[0] */
	gint ColumnWidth[NUMBER_COLUMN];
	/* Order of each column ex: "game name" column is the ColumnOrder[0] th column */
	gint ColumnOrder[NUMBER_COLUMN];
	/* ColumnShown[0]==true -> "game name" column is shown */
	bool ColumnShown[NUMBER_COLUMN];
	gchar *SaveVersion;
	GdkColor clone_color;
	gint ResetGUI;
	gint ResetGameDefaults;
	
	/* directories specification */
	gchar **RomPath;
	gchar **SamplePath;
	gchar *ArtworkDirectory;
	gchar *SnapshotDirectory;
	gchar *VideoDirectory;
	//gchar *HiscoreDirectory;
	gchar *FlyerDirectory;
	gchar *CabinetDirectory;
	gchar *MarqueeDirectory;
	gchar *TitleDirectory;
	//gchar *DiffDirectory;

	gchar *IconDirectory;

	//gchar *InputDirectory;
	//gchar *NVRamDirectory;
	//gchar *MemCardDirectory;
	//gchar *ConfigDirectory;
	//gchar *StateDirectory;
	gchar *CtrlrDirectory;
	//gchar *inipath;
	
	/* specifics option to GXMame (path to catver, common path...)
	   not in dir.ini */
	gchar *catverDirectory;
	gchar *CheatFile;
 	gchar *HiscoreFile;
 	gchar *HistoryFile;
 	gchar *MameInfoFile;
	
	gchar *sysinfoFile;
	gchar *messBiosDirectory;
	
	/* GUI Joystick options */
	bool gui_joy;
	gchar *Joystick_in_GUI;
	/* Don't pass any options to xmame */
	bool use_xmame_options;
	gint iconSize;
	bool scaledScreenshot;
	gint kxmameGeometry[5];
	gchar *messSnapDirectory;
	bool showVideoPreview;
};

// typedef struct {
// 	folder_filters_list FolderID;
// 	Columns_type type;
// 	bool is;
// 	const gchar *value;
// 	gint int_value; /* should be a union with value */
// 	bool update_list;
// } simple_filter;

/* global variables */
extern XmameExecutable *current_exec; /* pointer in the xmame_table */

extern guint visible_games;

//extern simple_filter *current_filter;
extern bool displayedlist_keypressed;
extern Joystick *joydata;
#ifndef KXMAME
GdkPixbuf *Status_Icons[NUMBER_STATUS];
#endif
extern struct gui_prefs_struct gui_prefs;

extern bool dirty_icon_cache;

/* Column number that is used in the gamelist popup menu */
extern gint ColumnHide_selected;

/* Debug Functions */
void column_debug (void);

// /* Others Functions */
// bool
// game_filtered (RomEntry * rom);

void
launch_emulation (RomEntry *rom, const gchar *command_line);

//void play_mess_game(KURL filename);
void play_game (RomEntry *rom);

void
exit_gxmame (void);

const gchar *rom_entry_get_list_name(RomEntry *rom);

void
playback_game (RomEntry *rom, const gchar *user_data);

void
record_game (RomEntry *rom, const gchar *user_data);

/* Columns management functions */
void
update_columns_tab (void);

GList*
get_columns_shown_list (void);

GList*
get_columns_hidden_list (void);

void gxmame_init(void);
void exit_gxmame();

#endif /* __GXMAME_H__ */
