/***************************************************************************
 *   Copyright (C) 2005 by Nguyen The Toan   *
 *   nguyenthetoan@gmail.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <kcolordialog.h>
#include <qdragobject.h>
//#include <kprinter.h>
#include <qpainter.h>
#include <qkeysequence.h>
#include <qpaintdevicemetrics.h>
#include <qlineedit.h>
#include <qprogressbar.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qgroupbox.h>
#include <qradiobutton.h>

#include <kmessagebox.h>
#include <kglobal.h>
#include <kdebug.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kdeversion.h>
#include <kstatusbar.h>
#include <kaccel.h>
#include <kio/netaccess.h>
#include <kfiledialog.h>
#include <kconfig.h>
#include <kurl.h>
#include <kurldrag.h>
#include <kurlrequesterdlg.h>
#include <kpopupmenu.h>
#include <kdialogbase.h>
#include <qhbox.h>
#include <qframe.h>
#include <qvariant.h>
#include <qwidget.h>
#include <kmainwindow.h>
#include <qsize.h>
#include <qlabel.h>
#include <qcheckbox.h>

#include <kiconloader.h>
#include <kstdaccel.h>
#include <kaction.h>
#include <kstdaction.h>

#include <math.h>
#define	BUFFER_SIZE	2048


#include "kxmame.h"
#include "pref.h"
#include "dirselectiondialog.h"
#include "koselectaction.h"
#include "auditdialog.h"

#include "io.h"
#include "game_options.h"
#include "options_string.h"
#include "common.h"
#include "kxmame_joy.h"

extern "C" {
#include <unistd.h>
#include <stdlib.h>

#include <glib.h>
}

bool globalIsMess;
kxmameView *mainView;
kxmamePreferences *mainConfigDialog;

kxmame::kxmame()
	: KMainWindow( 0, "kxmame" ), m_view(new kxmameView(this))
{
	isInPrefDialog = FALSE;
	mainConfigDialog = NULL;
	setAcceptDrops(false);
	setCentralWidget(m_view);
	setupActions();
	
	mainView = m_view;
	
	statusBar()->show();
	statusBar()->insertItem("",statusBarGameStatId,0,TRUE);
	statusBar()->insertItem("",statusBarGameTotalId,0,TRUE);
	
	setupGUI( ToolBar|Keys|StatusBar|Save|Create, "kxmameui.rc");
	
	connect(m_view, SIGNAL(signalChangeStatusbar(RomEntry *)),
		this,   SLOT(changeStatusbar(RomEntry *)));
	connect(m_view, SIGNAL(signalChangeCaption(const QString&)),
		this,   SLOT(changeCaption(const QString&)));
	connect(m_view, SIGNAL(signalChangeExpandCollapse()),
		this,   SLOT(changeExpandCollapse()));
	connect(m_view, SIGNAL(signalChangeFavorite(bool)),
		this,   SLOT(changeFavorite(bool)));
	connect(m_view, SIGNAL(signalSetupMameMessUI()),
		this,   SLOT(setupMameMessUI()));
	connect(m_view, SIGNAL(signalSelectNextExec()),
		this, 	SLOT(select_next_executable()));
	
	resize(QSize(gui_prefs.GUIWidth, gui_prefs.GUIHeight));
	m_view->finalize();

}

kxmame::~kxmame(){}

void kxmame::exit()
{
	delete m_view;
	kapp->quit();
}

void kxmame::setupActions()
{
	mConfigAction = new KAction(i18n("Properties"), "configure", 0,
				this, SLOT(romOptionsPreferences()),
				actionCollection(), "properties");
	KAction *mPlayAction = new KAction(i18n("Play"), "player_play", 0,
				m_view, SLOT(playGame()),
				actionCollection(), "play");
	mPlayExtAction = new KAction(i18n("Play using alternative emulator"), "player_play", 
				i18n("Ctrl+Shift+P"),
				m_view, SLOT(playGameAlternative()),
				actionCollection(), "playExternal");
	KAction *mRecordAction = new KAction(i18n("Play and Record Input..."), "filesave", 0,
				m_view, SLOT(playRecordGame()),
				actionCollection(), "record");
	KAction *mReplayAction = new KAction(i18n("Playback Input..."), "player_play", 0,
				m_view, SLOT(playbackGame()),
				actionCollection(), "replay");
	mAddFavoriteAction = new KAction(i18n("Add to 'Favorites'"), "bookmark_add", 0,
				m_view, SLOT(addFavorites()),
				actionCollection(), "addFavorite");    
	mRemoveFavoriteAction = new KAction(i18n("Remove from 'Favorites'"), "button_cancel", 0,
				m_view, SLOT(removeFavorites()),
				actionCollection(), "removeFavorite");
	
	mPlayAction->plug(m_view->gameListContextMenu);
	m_view->gameListContextMenu->insertSeparator();
	mRecordAction->plug(m_view->gameListContextMenu);
	mReplayAction->plug(m_view->gameListContextMenu);
	m_view->MessRomSelector()->dir->mPlayAction = mPlayAction;
	m_view->MessRomSelector()->dir->mPlayExtAction = mPlayExtAction;
	m_view->MessRomSelector()->dir->mRecordAction = mRecordAction;
	m_view->MessRomSelector()->dir->mReplayAction = mReplayAction;
	
	m_view->gameListContextMenu->insertSeparator();
	mAddFavoriteAction->plug(m_view->gameListContextMenu);
	mRemoveFavoriteAction->plug(m_view->gameListContextMenu);
	m_view->gameListContextMenu->insertSeparator();
	mConfigAction->plug(m_view->gameListContextMenu);
	//m_view->gameListContextMenu->setKeyboardShortcutsEnabled(TRUE);
	
	mAuditAllAction = new KAction(i18n("&Audit All Games"), "reload", 0,
				this, SLOT(gameAudit()),
				actionCollection(), "auditall");
	new KAction(i18n("&Quit"), "exit", 0,
				this, SLOT(exit()),
				actionCollection(), "exit");
	mShowFolderAction =  
			new KToggleAction(i18n("Show Fold&er List"), "view_choose", 0,
				m_view, SLOT(toggleFilter()),
				actionCollection(), "togglefilter");
	mShowFolderAction->setCheckedState(KGuiItem(i18n("Hide Fold&er List")));
	mShowFolderAction->setChecked(gui_prefs.ShowFolderList);
	mShowSideAction = 
			new KToggleAction(i18n("Show Scree&nshot Panel"), "view_right", 0,
				m_view, SLOT(toggleSide()),
				actionCollection(), "toggleside");
	mShowSideAction->setCheckedState(KGuiItem(i18n("Hide Scree&nshot Panel")));
	mShowSideAction->setChecked(gui_prefs.ShowScreenShot);
	mShowSearchAction = new KToggleAction(i18n("Show Search toolbar"), "find", "Ctrl+F",
					      m_view, SLOT(toggleSearch()),
					      actionCollection(), "search");
	mShowSearchAction->setCheckedState(KGuiItem(i18n("Hide Search toolbar")));
	mShowSearchAction->setChecked(m_view->isSearchToolbarShown());
/*	mQuickFilterAction = new KoSelectAction(i18n("&Quick system filter"), "filter",
				this, SLOT(quickFilter()),
				actionCollection(), "quickfilter");
	setupQuickFilter();*/
	KRadioAction *mListAction = new KRadioAction(i18n("List"), "view_text", 0,
				m_view, SLOT(listView()),
				actionCollection(), "list");
	mListAction->setExclusiveGroup("listmodes");
	KRadioAction *mListTreeAction = new KRadioAction(i18n("List Tree"), "view_tree", 0,
				m_view, SLOT(listTreeView()),
				actionCollection(), "listtree");
	mListTreeAction->setExclusiveGroup("listmodes");
	KRadioAction *mDetailAction = new KRadioAction(i18n("Details"), "view_text", 0,
				m_view, SLOT(detailView()),
				actionCollection(), "detail");
	mDetailAction->setExclusiveGroup("listmodes");
	KRadioAction *mDetailTreeAction = new KRadioAction(i18n("Details Tree"), "view_detailed", 0,
				m_view, SLOT(detailTreeView()),
				actionCollection(), "detailtree");
	mDetailTreeAction->setExclusiveGroup("listmodes");
	mListAction->setChecked(gui_prefs.current_mode==LIST);
	mListTreeAction->setChecked(gui_prefs.current_mode==LIST_TREE);
	mDetailAction->setChecked(gui_prefs.current_mode==DETAILS);
	mDetailTreeAction->setChecked(gui_prefs.current_mode==DETAILS_TREE);
	mExpandAction = new KAction(i18n("Expand All"), "2downarrow", 0,
				m_view, SLOT(expandGameList()),
				actionCollection(), "expand");
	mCollapseAction = new KAction(i18n("Collapse All"), "2uparrow", 0,
				m_view, SLOT(collapseGameList()),
				actionCollection(), "collapse");
	changeExpandCollapse();
	
	mColumnLayoutAction = new KAction(i18n("Column Layout..."), 0, 0,
				m_view, SLOT(columnsLayout()),
				actionCollection(), "columns");
	mRefreshAction =  new KAction(i18n("Refresh"), "reload", 0,
				this, SLOT(gameRefresh()),
				actionCollection(), "refresh");
	new KAction(i18n("&Directories..."), "folder", 0,
				this, SLOT(directoriesSetup()),
				actionCollection(), "directories");
	mExecutablesAction = new KoSelectAction(i18n("&Executable"), "exec",
				this, SLOT(execChanged()),
				actionCollection(), "executables");
	setupExecutablesSelection();
	
	mRebuildAction = new KAction(i18n("&Rebuild Game List"), "reload", 0,
				this, SLOT(gameList()),
				actionCollection(), "gamelist");
/*	new KAction(i18n("Clone &Color..."), "colorize", 0,
				this, SLOT(cloneColor()),
				actionCollection(), "cloneColor");*/
	KStdAction::preferences(this, SLOT(optionsPreferences()), actionCollection());
}

void kxmame::setupMameMessUI()
{
	if(globalIsMess) {
		mShowFolderAction->setEnabled(FALSE);
		mColumnLayoutAction->setEnabled(FALSE);
		mAuditAllAction->setText(i18n("&Audit All BIOSes"));
		mRebuildAction->setText(i18n("&Rebuild System List"));
		//mShowSearchAction->setEnabled(FALSE);
		mRefreshAction->setEnabled(FALSE);
		mPlayExtAction->setEnabled(gui_prefs.allowAlternative);
	} else {
		mShowFolderAction->setEnabled(TRUE);
		mColumnLayoutAction->setEnabled(TRUE);
		mAuditAllAction->setText(i18n("&Audit All Games"));
		mRebuildAction->setText(i18n("&Rebuild Game List"));
		//mShowSearchAction->setEnabled(TRUE);
		//mShowSearchAction->setChecked(m_view->isSearchToolbarShown());
		mRefreshAction->setEnabled(TRUE);
		mPlayExtAction->setEnabled(FALSE);
	}
}
void kxmame::gameRefresh()
{
	GList *list_pointer;
	RomEntry *rom;
	
	mRefreshAction->setEnabled(FALSE);
	/* remove all information concerning the presence of roms */
	for (list_pointer = g_list_first (game_list.roms); list_pointer; list_pointer = g_list_next (list_pointer)) {
		rom = (RomEntry *)list_pointer->data;
		rom->has_roms = UNKNOWN;
	}
	/* refresh the display */
	//create_gamelist_content ();

	game_list.not_checked_list = g_list_copy (game_list.roms);

	quick_check ();
	/* final refresh only if we are in AVAILABLE or UNAVAILABLE Folder*/
	if ((gui_prefs.FolderID == AVAILABLE) || (gui_prefs.FolderID == UNAVAILABLE)) {
		m_view->filterGames();
		m_view->updateGameListView();
		//create_gamelist_content ();
		GXMAME_DEBUG ("Final Refresh");
	}
	mRefreshAction->setEnabled(TRUE);
}

void kxmame::cloneColor()
{
	QColor myColor = QColor(
			gui_prefs.clone_color.red  *256/65535,
			gui_prefs.clone_color.green*256/65535,
			gui_prefs.clone_color.blue *256/65535);
	
	int r,g,b;
	
	int result = KColorDialog::getColor( myColor );
	if ( result == KColorDialog::Accepted ) {
		myColor.getRgb(&r, &g, &b);
		gui_prefs.clone_color.red = (int)(65535.0/256.0*r);
		gui_prefs.clone_color.green = (int)(65535.0/256.0*g);
		gui_prefs.clone_color.blue = (int)(65535.0/256.0*b);
		m_view->GameListView()->triggerUpdate();
	}
}


void kxmame::setupExecutablesSelection()
{
	QStringList execs;
	int i;
	gchar *full_name;
	XmameExecutable *exec;
	
        /* Make sure we have a default executable
           if we have anything in the table
        */
        if (!current_exec)
                current_exec = xmame_table_get_by_index (0);

	mExecutablesAction->popupMenu()->clear();
	
        for (i = 0; ; i++) {
                exec = xmame_table_get_by_index (i);

                if (!exec)
                        break;

                full_name = g_strdup_printf ("%s (%s) %s", exec->name, exec->target, exec->version);
		mExecutablesAction->popupMenu()->insertItem(full_name,i);
		g_free(full_name);

                if (exec == current_exec) {
			current_exec_idx = i;
                        set_current_executable (exec);
			mExecutablesAction->setCurrentSelection(i);
                }
	}
	if(!current_exec) current_exec_idx = -1;
}
/*
void kxmame::setupQuickFilter()
{
	mQuickFilterAction->popupMenu()->clear();
	mQuickFilterAction->popupMenu()->insertItem(i18n("All"),0);
	mQuickFilterAction->popupMenu()->insertItem(i18n("Originals"),1);
	mQuickFilterAction->popupMenu()->insertItem(i18n("Clones"),2);
	mQuickFilterAction->popupMenu()->insertItem(i18n("Favorites"),3);
//	mQuickFilterAction->popupMenu()->insertItem(i18n("Nintendo"),4);
//	mQuickFilterAction->popupMenu()->insertItem(i18n("Sega"),5);
	mQuickFilterAction->setCurrentSelection(0);
}*/

void kxmame::execChanged()
{
	current_exec_idx = mExecutablesAction->currentSelection();
	set_current_executable(xmame_table_get_by_index(current_exec_idx));
}

// void kxmame::quickFilter()
// {
// 	switch(mQuickFilterAction->currentSelection()) {
// 		case 0:
// 			m_view->quickFilter( ALL, NULL);
// 			break;
// 		case 1:
// 			m_view->quickFilter( ORIGINALS, NULL);
// 			break;
// 		case 2:
// 			m_view->quickFilter( CLONES, NULL);
// 			break;
// 		case 3:
// 			m_view->quickFilter( FAVORITES, NULL);
// 			break;
// 		default:
// 			break;
// 	}
// }

void kxmame::gameList()
{
	GXMAME_DEBUG ("recreate game list");
	gamelist_parse (current_exec);
	GXMAME_DEBUG ("reload everything");
	gamelist_save ();
	load_games_ini ();
	load_catver_ini ();
	m_view->setupGameIcons();
	m_view->updateFilterList();
	m_view->filterGames();
	m_view->updateGameListView();
}

void kxmame::select_next_executable()
{
	int total = xmame_table_size( );
	if(total){
		current_exec_idx ++;
		if (current_exec_idx==total) current_exec_idx=0;
		set_current_executable( xmame_table_get_by_index(current_exec_idx));
	}
}

void kxmame::set_current_executable (XmameExecutable *new_exec)
{
	bool exchangeMameMess = FALSE, needReload = FALSE;
	
        if (new_exec) {
                GXMAME_DEBUG ("Executable changed to %s", new_exec->path);
        }
	
	if(new_exec) {
		if ( ( globalIsMess && (!new_exec->isMess) )||
				     ( (!globalIsMess) && (new_exec->isMess) ) ) {
			exchangeMameMess = TRUE;
			if ((!mSplashScreen) && (!globalIsMess) && 
				( (gui_prefs.current_mode==DETAILS)||(gui_prefs.current_mode==DETAILS_TREE)) )
				m_view->saveGameColumnWidth();
			globalIsMess = !globalIsMess;
		}
	}
	
        current_exec = new_exec;

	/* check if the executable is still valid */
	if (!xmame_executable_is_valid (new_exec)) {
		if (new_exec) {
			gxmame_message (ERROR, NULL, i18n("%1 is not a valid executable").
				arg(new_exec->path) );
		}
		mConfigAction->setEnabled(FALSE);
		mAuditAllAction->setEnabled(FALSE);
	} else {
		mConfigAction->setEnabled(TRUE);
		mAuditAllAction->setEnabled(TRUE);
		
		if (exchangeMameMess) {
			/* Reload gamelist */
			gamelist_free( );
			gamelist_init( );
			if ( gamelist_load( ) ) {
				load_games_ini( );
				load_catver_ini( );
			}
		}
		
		if (gamelist_check (new_exec) || exchangeMameMess ) {
			m_view->GameListView()->clearSelection();
			/* mSplashScreen!=0 means we are at kxmamestartup */
			if(!mSplashScreen){
				m_view->updateFilterList();
				needReload = TRUE;
			}
		}
	}
	
	if(!mSplashScreen)
		m_view->setupMameMessView();
	
	if(needReload) {
		m_view->setupGameIcons();
		m_view->filterGames();
		m_view->updateGameListView();
	}
}
	
void kxmame::gameAudit()
{
	m_view->stopVideo();
	
	auditDialog *dlg;
	
	FILE *xmame_pipe;
	gchar line[BUFFER_SIZE];
	gchar title[BUFFER_SIZE];
	gchar numb[10];
	gfloat done;
	guint nb_checked = 1, nb_good = 0, nb_incorrect = 0, nb_bestavailable = 0, nb_notfound = 0;
	gboolean error_during_check = FALSE, game_found;
	gchar *p, *name;
	gchar *rompath_option;
	GList *listpointer;
	RomEntry *tmprom = NULL;
	guint status;
//	GtkTextIter text_iter;
	const gchar *option_name;	
	
	joy_focus_off();
	
	if (!current_exec) {
		gxmame_message (ERROR, NULL, i18n("No xmame/xmess executables defined"));
		goto exit_audit;
	}

	gamelist_check (current_exec);

	
	if (!xmame_get_options (current_exec))
		goto exit_audit;

	option_name = xmame_get_option_name (current_exec, "verifyroms");

	if (!option_name) {
		gxmame_message (ERROR, NULL, 
				i18n("Don't know how to verify %1 with this version of %2.").
						arg(globalIsMess? i18n("bioses"):i18n("roms")).
						arg(globalIsMess? i18n("xmess"):i18n("xmame")));
		goto exit_audit;
	}

	if(globalIsMess) rompath_option = create_biospath_options_string (current_exec);
	else rompath_option = create_rompath_options_string (current_exec);
		
	xmame_pipe = xmame_open_pipe (current_exec, "-%s %s",
				      option_name, rompath_option);
	
	if (!xmame_pipe) {
		GXMAME_DEBUG ("Could not run audit");
		g_free (rompath_option);
		goto exit_audit;
	}

	//fprintf(stderr,"-%s %s\n", option_name, rompath_option);
	
	dlg = new auditDialog(0);
	
	this->hide();
	
	dlg->setModal(TRUE);
	dlg->show();

	if(globalIsMess) {
		/* by default, assume no BIOS is needed */
		GList *listpointer;
		RomEntry *tmprom;
		for (listpointer = g_list_first (game_list.roms);
			(listpointer);
			listpointer= g_list_next (listpointer)) {
				tmprom = (RomEntry *) listpointer->data;
				tmprom->has_samples = tmprom->has_roms = NOTNEEDED;
				tmprom->nb_samples = tmprom->nb_roms = 0;
			}
		dlg->romGroupBox->setTitle("Bios");
	}
	
	/* Loading */
	fflush (xmame_pipe);
	while (fgets (line, BUFFER_SIZE, xmame_pipe) && (!dlg->audit_cancelled)) {
		/* jump the last comments */
		if (line[0] == '\0' || line[1] == '\0')
			break;
		
		//gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER (details_check_buffer), &text_iter);
		if (!strncmp (line, "romset", 6)) {
			for (p = name = line + 7; (*p && (*p != ' ') && (*p != '\n')); p++);
			*p = '\0';
			p++;

			done = (gfloat) ( (gfloat) (nb_checked) / (gfloat) (game_list.num_games));

			if (!strncmp (p, "correct", 7)) {
				nb_good++;
				g_snprintf (numb, 10, "%d", nb_good);
				//gtk_label_set_text (GTK_LABEL (correct_roms_value), numb);
				dlg->romCorrectLabel->setText(numb);
				g_snprintf (numb, 10, "%d", nb_good + nb_incorrect + nb_notfound + nb_bestavailable);
				//gtk_label_set_text (GTK_LABEL (total_roms_value), numb);
				dlg->romTotalLabel->setText(numb);
				status = 1;
			} else if (!strncmp (p, "incorrect", 9) && error_during_check == TRUE) {
				nb_incorrect++;
				g_snprintf (numb, 10, "%d", nb_incorrect);
				//gtk_label_set_text (GTK_LABEL (incorrect_roms_value), numb);
				dlg->romIncorrectLabel->setText(numb);
				g_snprintf (numb, 10, "%d", nb_good + nb_incorrect + nb_notfound + nb_bestavailable);
				//gtk_label_set_text (GTK_LABEL (total_roms_value), numb);
				dlg->romTotalLabel->setText(numb);
				sprintf (title, "%s: Incorrect\n", line);
				//gtk_text_buffer_insert (GTK_TEXT_BUFFER (details_check_buffer), &text_iter, title, -1);
				dlg->detailEdit->append(title);
				status = 0;
			} else if (!strncmp (p, "not found", 9)) {
				nb_notfound++;
				g_snprintf (numb, 10, "%d", nb_notfound);
				//gtk_label_set_text (GTK_LABEL (notfound_roms_value), numb);
				dlg->romNotFoundLabel->setText(numb);
				g_snprintf (numb, 10, "%d", nb_good + nb_incorrect + nb_notfound + nb_bestavailable);
				//gtk_label_set_text (GTK_LABEL (total_roms_value), numb);
				dlg->romTotalLabel->setText(numb);
				sprintf (title, "%s: Not found\n", line);
				//gtk_text_buffer_insert (GTK_TEXT_BUFFER (details_check_buffer), &text_iter, title, -1);
				dlg->detailEdit->append(title);
				status = 0;
			} else if (!strncmp (p, "best available", 14)) {
				nb_bestavailable++;
				g_snprintf (numb, 10,"%d", nb_bestavailable);
				//gtk_label_set_text (GTK_LABEL (bestavailable_roms_value), numb);
				dlg->romBestLabel->setText(numb);
				g_snprintf (numb, 10, "%d", nb_good + nb_incorrect + nb_notfound + nb_bestavailable);
				//gtk_label_set_text (GTK_LABEL (total_roms_value), numb);
				dlg->romTotalLabel->setText(numb);
				status = 1;
			} else {
				printf ("????\n");
				status = 2;
			}

			/* find the rom in the list */
			for (listpointer = g_list_first (game_list.roms), game_found = FALSE;
				(listpointer != NULL);
				listpointer = g_list_next (listpointer)) {
					tmprom = (RomEntry *) listpointer->data;
					if (!strcmp (tmprom->romname, name)) {
						game_found = TRUE;
						break;
					}
				}
			if (game_found) {
				tmprom->has_roms = (RomStatus)status;
				//tmprom->status = (status == CORRECT);

				if (tmprom->the_trailer && gui_prefs.ModifyThe)
					g_snprintf (title, BUFFER_SIZE, "%s, The %s", tmprom->gamename, tmprom->gamenameext);
				else if (tmprom->the_trailer && !gui_prefs.ModifyThe)
					g_snprintf (title, BUFFER_SIZE, "The %s %s", tmprom->gamename, tmprom->gamenameext);
				else
					g_snprintf (title, BUFFER_SIZE, "%s %s", tmprom->gamename, tmprom->gamenameext);
			} else { /* haven't found the game, just diplay the gamename */
				g_snprintf (title, BUFFER_SIZE, "%s", name);
			}
			/* continue with the GUI */
			nb_checked++;
			error_during_check = FALSE;

			//gtk_label_set_text (GTK_LABEL (checking_games_label), title);
			dlg->gameLabel->setText(title);

			//gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (roms_check_progressbar), done);
			dlg->romProgressBar->setProgress( int(round(done * 100.0)) );
		} else if (!strncmp (line, "name", 4) || !strncmp (line, "---", 3)) {
			/* do nothing */
		} else {
			//gtk_text_buffer_insert (GTK_TEXT_BUFFER (details_check_buffer), &text_iter, line, -1);
			dlg->detailEdit->append(line);
			error_during_check = TRUE;
		}

/*		while (gtk_events_pending ())
			gtk_main_iteration ();*/
		kapp->processEvents ();
		fflush (xmame_pipe);
	}

	if (dlg->audit_cancelled) {
		// Forcibly kill xmame
		gchar *execname;
		
		execname = g_path_get_basename (current_exec->path);
		g_snprintf(title, BUFFER_SIZE, "killall %s", execname);
		system(title);
		g_free(execname);
		
		g_free (rompath_option);
		dlg->setCaption(i18n("Audit Stopped"));
		dlg->gameLabel->setText( i18n("Stopped"));
		goto audit_finished;
	}

	xmame_close_pipe (xmame_pipe);
	
	/* Samples now */
	nb_good = nb_incorrect = 0;
	nb_checked = 1;

	xmame_pipe = xmame_open_pipe (current_exec, "-%s %s", 
				      xmame_get_option_name (current_exec, "verifysamples"),
				      rompath_option);

	g_free (rompath_option);

	/* Loading */
	while (fgets (line, BUFFER_SIZE, xmame_pipe) && !dlg->audit_cancelled) {
		/* jump the last comments */
		if (line[0] == '\0' || line[1] == '\0')
			break;
		
		//gtk_text_buffer_get_end_iter (GTK_TEXT_BUFFER (details_check_buffer), &text_iter);
		if (!strncmp (line, "sampleset", 9)) {
			for (p = name = line + 10; (*p && (*p != ' ') && (*p != '\n')); p++);
			*p = '\0';
			p++;

			done = (gfloat) ( (gfloat) (nb_checked) / (gfloat) (game_list.num_sample_games));
			if (!strncmp (p, "correct", 7)) {
				nb_good++;
				g_snprintf (numb, 10,"%d", nb_good);
				//gtk_label_set_text (GTK_LABEL (correct_samples_value), numb);
				dlg->sampleCorrectLabel->setText(numb);
				g_snprintf (numb, 10,"%d", nb_good+nb_incorrect);
				//gtk_label_set_text (GTK_LABEL (total_samples_value), numb);
				dlg->sampleTotalLabel->setText(numb);
				status = 1;
			} else if (!strncmp (p, "incorrect", 9) && error_during_check == TRUE) {
				nb_incorrect++;
				g_snprintf (numb, 10, "%d", nb_incorrect);
				//gtk_label_set_text (GTK_LABEL (incorrect_samples_value), numb);
				dlg->sampleIncorrectLabel->setText(numb);
				g_snprintf (numb, 10, "%d", nb_good + nb_incorrect);
				//gtk_label_set_text (GTK_LABEL (total_samples_value), numb);
				dlg->sampleTotalLabel->setText(numb);
				status = 0;
			} else
				status = 2;

				/* find the rom in the list */
				for (listpointer = g_list_first (game_list.roms), game_found = FALSE;
					(listpointer != NULL);
					listpointer = g_list_next (listpointer)) {
						tmprom = (RomEntry *) listpointer->data;
						if (!strcmp (tmprom->romname, name)) {
						game_found = TRUE;
						break;
						}
					}
					if (game_found) {
						tmprom->has_samples = (RomStatus)status;
						if (tmprom->the_trailer && gui_prefs.ModifyThe)
						g_snprintf (title, BUFFER_SIZE, "%s, The %s", tmprom->gamename, tmprom->gamenameext);
						else if (tmprom->the_trailer && !gui_prefs.ModifyThe)
						g_snprintf (title, BUFFER_SIZE, "The %s %s", tmprom->gamename, tmprom->gamenameext);
						else
						g_snprintf (title, BUFFER_SIZE, "%s %s", tmprom->gamename, tmprom->gamenameext);
					}
					/*continue with the GUI */
					nb_checked++;
					error_during_check = FALSE;
					g_snprintf (title, BUFFER_SIZE, "%s", name);
					//gtk_label_set_text (GTK_LABEL (checking_games_label), title);
					dlg->gameLabel->setText(title);

					//gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (samples_check_progressbar), done);
					dlg->sampleProgressBar->setProgress( int(round(done * 100.0)) );
		} else {
			//gtk_text_buffer_insert (GTK_TEXT_BUFFER (details_check_buffer), &text_iter, line, -1);
			dlg->detailEdit->append(line);
			error_during_check = TRUE;
		}
/*		while (gtk_events_pending ())
			gtk_main_iteration ();*/
		kapp->processEvents ();
		fflush (xmame_pipe);
	}
	if (dlg->audit_cancelled) {
		// Forcibly kill xmame
		gchar *execname;
		
		execname = g_path_get_basename (current_exec->path);
		g_snprintf(title, BUFFER_SIZE, "killall %s", execname);
		system(title);
		g_free(execname);
		
		dlg->setCaption(i18n("Audit Stopped"));
		dlg->gameLabel->setText( i18n("Stopped"));
		goto audit_finished;
	}

	pclose (xmame_pipe);

	dlg->sampleProgressBar->setProgress( 100 );//This is needed for xmess
	dlg->romProgressBar->setProgress( 100 ); //This is needed for xmess
	dlg->setCaption(i18n("Audit done"));
	dlg->gameLabel->setText( i18n("Done"));
	dlg->detailEdit->append(i18n("Audit done"));

audit_finished:

	dlg->stopButton->setEnabled(FALSE);
	dlg->closeButton->setEnabled(TRUE);
	while (! dlg->audit_closed) {
		kapp->processEvents();
		usleep(500);
	}
	
//	create_gamelist_content ();
	m_view->filterGames();
	m_view->updateGameListView();

	this->show();
	dlg->hide();
	
	delete dlg;

exit_audit:
	joy_focus_on();
	return;
}

void kxmame::directoriesSetup()
{
    dirSelectionDialog dlg;

    gchar *currentIconDir = g_strdup(gui_prefs.IconDirectory);
    gchar *currentExecPath = NULL;

    if(current_exec) 
	currentExecPath = g_strdup(current_exec->path);

    if (dlg.exec()== QDialog::Accepted)
    {
	    /* free the main config paths*/
	    /* GXMame */
	    g_free (gui_prefs.FlyerDirectory);
	    g_free (gui_prefs.CabinetDirectory);
	    g_free (gui_prefs.MarqueeDirectory);
	    g_free (gui_prefs.TitleDirectory);
	    g_free (gui_prefs.IconDirectory);
	    /* XMame basic */
	    g_strfreev (gui_prefs.SamplePath);
	    g_free (gui_prefs.mameArtworkDirectory);
	    g_free (gui_prefs.messArtworkDirectory);
	    /* XMame additional */
	    g_free (gui_prefs.SnapshotDirectory);
	    g_free (gui_prefs.VideoDirectory);
	    g_free (gui_prefs.HistoryFile);
	    g_free (gui_prefs.MameInfoFile);
	    g_free (gui_prefs.mameCheatFile);
	    g_free (gui_prefs.messCheatFile);
	    g_free (gui_prefs.HiscoreFile);
	    /* User Resources */
	    g_free (gui_prefs.mameHiscoreDirectory);
	    g_free (gui_prefs.mameInputDirectory);
	    g_free (gui_prefs.mameConfigDirectory);
	    g_free (gui_prefs.mameNVRamDirectory);
	    g_free (gui_prefs.mameMemCardDirectory);
	    g_free (gui_prefs.mameStateDirectory);
	    g_free (gui_prefs.mameInipath);
	    g_free (gui_prefs.mameDiffDirectory);
	    
	    g_free (gui_prefs.messHiscoreDirectory);
	    g_free (gui_prefs.messInputDirectory);
	    g_free (gui_prefs.messConfigDirectory);
	    g_free (gui_prefs.messNVRamDirectory);
	    g_free (gui_prefs.messMemCardDirectory);
	    g_free (gui_prefs.messStateDirectory);
	    g_free (gui_prefs.messInipath);
	    g_free (gui_prefs.messDiffDirectory);
	    /* mess paths */
	    g_free (gui_prefs.sysinfoFile);
	    g_free (gui_prefs.messBiosDirectory);
	    g_free (gui_prefs.messSnapDirectory);

	    /* and replace them by the new ones*/
	    /* GXMame */
	    if (strcmp (gui_prefs.catverDirectory, dlg.catverEdit->text())) {
		    GXMAME_DEBUG ("catver changed %s - %s",gui_prefs.catverDirectory, gtk_editable_get_chars (GTK_EDITABLE (common_path_entry), 0, -1));
		    g_free (gui_prefs.catverDirectory);
		    gui_prefs.catverDirectory = g_strdup(dlg.catverEdit->text());
		    /* Updating with the new catver file */
		    g_list_foreach (game_list.versions, (GFunc)g_free, NULL);
		    g_list_free (game_list.versions);
		    game_list.versions = NULL;
		    load_catver_ini ();

		    m_view->updateFilterList();
		    m_view->filterGames();
		    m_view->updateGameListView();
		    //create_filterslist_content ();

		    /* Updating the UI if necessary */
/*		    if ( (current_filter->type == CATEGORY) || (current_filter->type == MAMEVER)
					|| (gui_prefs.FolderID == CATEGORIES) || (gui_prefs.FolderID == VERSIONS) ) {
			    gui_prefs.FolderID = AVAILABLE;
			    gxmame_message (WARNING, GTK_WINDOW (directories_selection), i18n("Current Folder may not exist after loading the new catver file.\nMoving to the \"Available\" game folder"));
			    create_gamelist_content ();
					} else if ( (gui_prefs.current_mode == DETAILS || gui_prefs.current_mode == DETAILS_TREE)
										&& (gui_prefs.ColumnShown[MAMEVER]==TRUE || gui_prefs.ColumnShown[CATEGORY] == TRUE)) {
										create_gamelist_content ();
										}*/
	    }

	    gui_prefs.FlyerDirectory = g_strdup(dlg.flyerEdit->text());
	    gui_prefs.CabinetDirectory = g_strdup(dlg.cabinetEdit->text());
	    gui_prefs.MarqueeDirectory = g_strdup(dlg.marqueeEdit->text());
	    gui_prefs.TitleDirectory = g_strdup(dlg.snapEdit->text());
	    gui_prefs.IconDirectory = g_strdup(dlg.iconEdit->text());

	    if(strncmp(gui_prefs.IconDirectory, currentIconDir, strlen(currentIconDir)+1)) {
			m_view->setupGameIcons();
			m_view->updateGameListView();
	    }

	    /* XMame additional */
	    gui_prefs.SnapshotDirectory = g_strdup(dlg.snapShotEdit->text());
	    gui_prefs.VideoDirectory = g_strdup(dlg.videoEdit->text());
	    gui_prefs.HistoryFile = g_strdup(dlg.historyEdit->text());
	    gui_prefs.MameInfoFile = g_strdup(dlg.mameInfoEdit->text());
	    gui_prefs.HiscoreFile = g_strdup(dlg.highscoreEdit->text());
	    gui_prefs.mameCheatFile = g_strdup(dlg.cheatEdit->text());
	    gui_prefs.messCheatFile = g_strdup(dlg.messCheatEdit->text());
	    /* If the ctrlr directory has changed, we reload the default options */
	    if ( (dlg.controllerEdit->text() != QString::null)
			 || strcmp (gui_prefs.CtrlrDirectory, dlg.controllerEdit->text()))
	    {
		    g_free (gui_prefs.CtrlrDirectory);
		    gui_prefs.CtrlrDirectory = g_strdup(dlg.controllerEdit->text());
		    load_options (NULL);
	    }

	    /* User Resources */
	    gui_prefs.mameHiscoreDirectory = g_strdup(dlg.mameRadioButton->isChecked()?dlg.highscorePathEdit->text():dlg.mHighScore);
	    gui_prefs.mameInputDirectory = g_strdup(dlg.mameRadioButton->isChecked()?dlg.recordEdit->text():dlg.mRecord);
	    gui_prefs.mameConfigDirectory = g_strdup(dlg.mameRadioButton->isChecked()?dlg.gameConfigEdit->text():dlg.mConfig);
	    gui_prefs.mameNVRamDirectory = g_strdup(dlg.mameRadioButton->isChecked()?dlg.nvramEdit->text():dlg.mNvram);
	    gui_prefs.mameMemCardDirectory = g_strdup(dlg.mameRadioButton->isChecked()?dlg.memoryEdit->text():dlg.mMemory);
	    gui_prefs.mameStateDirectory = g_strdup(dlg.mameRadioButton->isChecked()?dlg.gameStatusEdit->text():dlg.mStatus);
	    gui_prefs.mameInipath = g_strdup(dlg.mameRadioButton->isChecked()?dlg.iniEdit->text():dlg.mIni);
	    gui_prefs.mameDiffDirectory = g_strdup(dlg.mameRadioButton->isChecked()?dlg.diffEdit->text():dlg.mDiff);
	    
	    gui_prefs.messHiscoreDirectory = g_strdup(dlg.messRadioButton->isChecked()?dlg.highscorePathEdit->text():dlg.mHighScore);
	    gui_prefs.messInputDirectory = g_strdup(dlg.messRadioButton->isChecked()?dlg.recordEdit->text():dlg.mRecord);
	    gui_prefs.messConfigDirectory = g_strdup(dlg.messRadioButton->isChecked()?dlg.gameConfigEdit->text():dlg.mConfig);
	    gui_prefs.messNVRamDirectory = g_strdup(dlg.messRadioButton->isChecked()?dlg.nvramEdit->text():dlg.mNvram);
	    gui_prefs.messMemCardDirectory = g_strdup(dlg.messRadioButton->isChecked()?dlg.memoryEdit->text():dlg.mMemory);
	    gui_prefs.messStateDirectory = g_strdup(dlg.messRadioButton->isChecked()?dlg.gameStatusEdit->text():dlg.mStatus);
	    gui_prefs.messInipath = g_strdup(dlg.messRadioButton->isChecked()?dlg.iniEdit->text():dlg.mIni);
	    gui_prefs.messDiffDirectory = g_strdup(dlg.messRadioButton->isChecked()?dlg.diffEdit->text():dlg.mDiff);

	    /* mess */
	    gui_prefs.sysinfoFile = g_strdup(dlg.messSysinfoPathEdit->text());
	    gui_prefs.messBiosDirectory = g_strdup(dlg.messBiosPathEdit->text());
	    gui_prefs.messSnapDirectory = g_strdup(dlg.messSnapPathEdit->text());
	    kxmame_replace(gui_prefs.AlternativeFile, g_strdup(dlg.alternativeEdit->text()));
	    gui_prefs.allowAlternative = dlg.alternativeCheck->isChecked();
	    
	    /* XMame basic */
	    gui_prefs.mameArtworkDirectory = g_strdup(dlg.artEdit->text());
	    gui_prefs.messArtworkDirectory = g_strdup(dlg.messArtEdit->text());
	    
	    uint size, i;
	    /* Transform the list content into a array of char terminated by a NULL element */
	    /* Samples Path */
	    size = dlg.sampleList->count();
	    if (size) {
		    gui_prefs.SamplePath = g_new (gchar *, (size+1));
		    for (i = 0; i < size; i++) {
			    gui_prefs.SamplePath[i] = g_strdup (dlg.sampleList->text(i));
		    }
		    gui_prefs.SamplePath[size] = NULL;
	    } else {
		    gui_prefs.SamplePath = g_new (gchar *, 1);
		    gui_prefs.SamplePath[0] = NULL;
	    }

	    /* Roms Path */
	    size = dlg.romList->count();
	    bool changed_flag = FALSE;
	    i = 0;
	    while (gui_prefs.RomPath[i])
		    i++;
	    if (i == size) {
		    for (i = 0; i < size; i++) {
			    if (strcmp (gui_prefs.RomPath[i], dlg.romList->text(i)))
				    changed_flag = TRUE;
		    }
	    } else {
		    changed_flag = TRUE;
	    }

	    if (changed_flag) {
		    GXMAME_DEBUG ("rom path changed");
		    if (size) {
			    g_strfreev (gui_prefs.RomPath);
			    gui_prefs.RomPath = g_new (gchar *, (size + 1));
			    for (i = 0; i < size; i++) {
				    gui_prefs.RomPath[i] = g_strdup (dlg.romList->text(i));
			    }
			    gui_prefs.RomPath[size] = NULL;
		    } else {
			    gui_prefs.RomPath = g_new (gchar *, 1);
			    gui_prefs.RomPath[0] = NULL;
		    }
		    /* Do we perform the quickcheck? */
		/*
		    GtkWidget *dialog;
		    gint result;
		    dialog = gtk_message_dialog_new (GTK_WINDOW (directories_selection),
		    GTK_DIALOG_MODAL,
		    GTK_MESSAGE_WARNING,
		    GTK_BUTTONS_YES_NO,
		    i18n("The Rom Path has been modified.\nDo you want to refresh the gamelist after the directory window is closed?"));
		    result = gtk_dialog_run (GTK_DIALOG (dialog));
		    switch (result)
		    {
		    case GTK_RESPONSE_YES:
		    refresh_game_list=TRUE;
		    break;
		    default:
		    break;
	    }
		    gtk_widget_destroy (dialog);
		*/
	    }

	    /* XMame Executables */
	    current_exec = NULL;
	    bool foundExec = FALSE;
	    XmameExecutable *tmpExec;
	    xmame_table_free ();
	    xmame_table_init ();
	    size = dlg.execList->count();
	    for (i = 0; i < size; i++) {
		tmpExec = xmame_table_add (dlg.execList->text(i));
		if(!foundExec && tmpExec && currentExecPath && 
			(!strcmp(tmpExec->path, currentExecPath))) {
			current_exec = tmpExec;
			foundExec = TRUE;
		}
	    }

	    /* remove and destroy the submenu */
	    //add_exec_menu ();
	    setupExecutablesSelection();

	    /* here we should already have a valid executable except if mame is not present in path */
	    if (!current_exec) {
		    //gxmame_message (ERROR, GTK_WINDOW (directories_selection), i18n("No valid xmame executables found"));
		    gxmame_message (ERROR, 0, i18n("No valid xmame/xmess executables found"));
	    }
	    m_view->setupMameMessView();
    }

    if(currentExecPath) g_free(currentExecPath);
    g_free(currentIconDir);

}

// void kxmame::saveProperties(KConfig *config)
// {
//     // the 'config' object points to the session managed
//     // config file.  anything you write here will be available
//     // later when this app is restored
// 
// #if KDE_IS_VERSION(3,1,3)
//         config->writePathEntry("iconSize", QString::number(gui_prefs.iconSize));
// #else
//         config->writeEntry("iconSize", QString::number(gui_prefs.iconSize));
// #endif
// }
// 
// void kxmame::readProperties(KConfig *config)
// {
//     // the 'config' object points to the session managed
//     // config file.  this function is automatically called whenever
//     // the app is being restored.  read in here whatever you wrote
//     // in 'saveProperties'
// 
//     QString url = config->readPathEntry("iconSize");
// 
//     if (!url.isEmpty())
// 	    gui_prefs.iconSize = url.toInt(0);
//     else
// 	    gui_prefs.iconSize = 16;
// 
// }

void kxmame::optionsPreferences()
{
	if(!current_exec) {
		gxmame_message(ERROR, NULL,i18n("No xmame/xmess executable found.\n"
			"Please use menu Settings->Directories to add an executable."));
		return;
	}

	isInPrefDialog = TRUE;
	kxmamePreferences dlg(NULL);
	mainConfigDialog = &dlg;
	if (dlg.exec())
	{
		memcpy(&default_options, (void *)(dlg.localGameOpts), sizeof(default_options));
		save_options(NULL, NULL);

		if(gui_prefs.iconSize != dlg.iconSize) {
			gui_prefs.iconSize = dlg.iconSize;
			m_view->saveGameColumnWidth();
			m_view->setupGameIcons();
			m_view->updateGameListView();
		}
		if(gui_prefs.scaledScreenshot != dlg.scaledScreenshot) {
			gui_prefs.scaledScreenshot = dlg.scaledScreenshot;
			m_view->setScaledScreenshot();
		}
		gui_prefs.GameCheck = dlg.GameCheck;
		gui_prefs.VersionCheck = dlg.VersionCheck;
		gui_prefs.use_xmame_options = dlg.use_xmame_options;
		gui_prefs.showVideoPreview = dlg.showVideoPreview;
		m_view->updateVideoPreview();
#ifdef ENABLE_JOYSTICK
		gui_prefs.gui_joy = dlg.gui_joy;
		g_free(gui_prefs.Joystick_in_GUI);
		gui_prefs.Joystick_in_GUI = g_strdup(dlg.Joystick_in_GUI);
		
		/* activate or desactivate joystick */
		joystick_close (joydata);
		joydata = NULL;
		if (gui_prefs.gui_joy) {
			if ((joydata = joystick_new (gui_prefs.Joystick_in_GUI)))
				k_message (i18n("Joystick %1 found").arg(joydata->device_name));
			else
				k_message (i18n("No Joystick found"));
		}
		
		gui_prefs.kxmameJoyButton[0]=dlg.joyButton[0];
		gui_prefs.kxmameJoyButton[1]=dlg.joyButton[1];
		gui_prefs.kxmameJoyButton[2]=dlg.joyButton[2];
		gui_prefs.kxmameJoyButton[3]=dlg.joyButton[3];
		gui_prefs.kxmameJoyButton[4]=dlg.joyButton[4];
		setupJoyEventReceivers();
#endif
	}
	isInPrefDialog = FALSE;
	mainConfigDialog = NULL;
}

void kxmame::romOptionsPreferences()
{
	if(!current_exec) {
		gxmame_message(ERROR, NULL,i18n("No xmame/xmess executable found"));
		return;
	}

	RomEntry *rom = m_view->currentRom();
		
	if(!rom) return;
	
	kxmamePreferences dlg(rom);
	// if user reset the options and press OK, nothing should be saved.
	if (dlg.exec() && dlg.isModified)
	{
		save_options(rom, dlg.localGameOpts);
	}
}

void kxmame::changeStatusbar(RomEntry *rom)
{
	QString line;

	if(rom) {
		statusBar()->message(rom_entry_get_list_name(rom) );
		if (rom->has_roms == 2)		line = i18n("Unknown");
		else if (rom->has_roms == 0)	
			line = globalIsMess ? i18n("BIOS missing") : i18n("ROMs missing");
		else if (rom->has_roms == NOTNEEDED)	line = i18n("BIOS not needed");
		else if (!rom->status)		line = i18n("Not working");
		else				line = i18n("Working");
	} else {
		statusBar()->message(i18n("No game selected"));
		line = "";
	}
	statusBar()->changeItem(line,statusBarGameStatId);

	if(globalIsMess)
		line = QString::number(visible_games)+" "+i18n("systems");
	else
		line = QString::number(visible_games)+" "+i18n("games");
	
	statusBar()->changeItem(line,statusBarGameTotalId);
}

void kxmame::changeFavorite(bool isFavorite)
{
	mAddFavoriteAction->setEnabled(!(isFavorite));
	mRemoveFavoriteAction->setEnabled(isFavorite);
}

void kxmame::changeExpandCollapse()
{
	mExpandAction->setEnabled( (gui_prefs.current_mode==LIST_TREE)
			||(gui_prefs.current_mode==DETAILS_TREE) );
	mCollapseAction->setEnabled((gui_prefs.current_mode==LIST_TREE)
			||(gui_prefs.current_mode==DETAILS_TREE) );
}

void kxmame::changeCaption(const QString& text)
{
	setCaption(text);
}
#include "kxmame.moc"
