/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.modes;

import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.DecryptMode;

public class DecryptCFB
extends DecryptMode {
    private CipherKey key;
    private int ibs;
    private int obs;
    private byte[] queue;
    private int IVBytes = 0;

    public CipherKey getKey() {
        return this.key;
    }

    public void setKey(CipherKey cipherKey) {
        this.key = cipherKey;
        this.ibs = cipherKey.plainBlockSize();
        this.obs = cipherKey.cipherBlockSize();
        this.queue = new byte[this.ibs];
        this.IVBytes = 0;
    }

    public int plainBlockSize() {
        return 1;
    }

    public synchronized byte[] decrypt(byte[] byArray, int n, int n2) {
        if (this.IVBytes < this.ibs) {
            int n3 = Math.min(this.ibs - this.IVBytes, n2);
            System.arraycopy(byArray, n, this.queue, this.IVBytes, n3);
            this.IVBytes += n3;
            if (this.IVBytes < this.ibs) {
                return new byte[0];
            }
            n += n3;
            n2 -= n3;
        }
        byte[] byArray2 = new byte[n2];
        int n4 = 0;
        int n5 = n + n2;
        byte[] byArray3 = new byte[this.obs];
        while (n < n5) {
            this.key.encrypt(this.queue, 0, byArray3, 0);
            byArray2[n4] = (byte)(byArray[n] ^ byArray3[0]);
            System.arraycopy(this.queue, 1, this.queue, 0, this.ibs - 1);
            this.queue[this.ibs - 1] = byArray[n];
            ++n;
            ++n4;
        }
        return byArray2;
    }

    public DecryptCFB(CipherKey cipherKey) {
        this.setKey(cipherKey);
    }

    public DecryptCFB() {
    }
}

