package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.util.CommonUtils;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.io.*;

/**
 * Contains the <tt>JDialog</tt> instance that shows "about" information
 * for the application.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class AboutWindow {
	/**
	 * Constant handle to the <tt>JDialog</tt> that contains about
	 * information.
	 */
	private final JDialog DIALOG = new JDialog();

	/**
	 * Constant handle to the <tt>ImageIcon</tt> to use for the about
	 * window.
	 */
	//private ImageIcon _icon =
	//GUIMediator.getThemeImage("searching.gif");

	/**
	 * Constant dimension for the dialog.
	 */
	private final Dimension DIALOG_DIMENSION = new Dimension(450, 400);

	/**
	 * Constant for the scolling pane of credits.
	 */
	private final ScrollingTextPane SCROLLING_PANE =
		new ScrollingTextPane(GUIMediator.getStringResource("ABOUT_FILE_NAME"));

	/**
	 * Check box to specify whether to scroll or not.
	 */
	private final JCheckBox SCROLL_CHECK_BOX = 
		new JCheckBox(GUIMediator.getStringResource(
            "ABOUT_SCROLL_CHECK_BOX_LABEL"));

	/**
	 * Constructs the elements of the about window.
	 */
	AboutWindow() {
		DIALOG.setModal(true);
		DIALOG.setResizable(false);
		DIALOG.setTitle(GUIMediator.getStringResource("ABOUT_TITLE"));
		SCROLLING_PANE.addHyperlinkListener(new HyperlinkListener() {
			public void hyperlinkUpdate(HyperlinkEvent he) {
				if(he.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
					return;
				}
				URL url = he.getURL();
				if(url == null) {
					return;
				}
				try {
					GUIMediator.openURL(url.toExternalForm());
				} catch(IOException e) {
					// who cares...
				}
			}
		});

		SCROLL_CHECK_BOX.setSelected(true);
		SCROLL_CHECK_BOX.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent ae) {
				if(SCROLL_CHECK_BOX.isSelected()) {
					SCROLLING_PANE.startScroll();
				}
				else {
					SCROLLING_PANE.stopScroll();
				}
			}
		});
		BoxPanel topPanel = new BoxPanel(BoxPanel.Y_AXIS);
		// set the main panel's border
		Border border = BorderFactory.createEmptyBorder(6,6,6,6);
		topPanel.setBorder(border);
		topPanel.add(GUIMediator.getVerticalSeparator());
		LogoPanel logo = new LogoPanel();
		logo.setSearching(true);
		topPanel.add(logo);
		topPanel.add(Box.createVerticalStrut(17));
		String labelStart =
		    GUIMediator.getStringResource("ABOUT_LABEL_START");
		String version = CommonUtils.getLimeWireVersion();
		String labelAddress =
		    GUIMediator.getStringResource("ABOUT_LABEL_ADDRESS");
		String[] strs = {labelStart+" "+version, labelAddress};
		MultiLineLabel label =
		    new MultiLineLabel(strs);
		label.setFont(new Font("Sans Serif", Font.PLAIN, 11));
		label.setForeground(Color.black);
		Dimension dim = new Dimension(DIALOG_DIMENSION.width-12, 40);
		label.setPreferredSize(dim);
		label.setMaximumSize(dim);
		BoxPanel labelPanel = new BoxPanel(BoxPanel.X_AXIS);
		labelPanel.add(Box.createRigidArea(
		    new Dimension((DIALOG_DIMENSION.width/2)-
						  ((label.getFontMetrics(label.getFont()).
						  stringWidth(labelAddress))/2), 0)));
		labelPanel.add(label);

		topPanel.add(labelPanel);
		topPanel.add(SCROLLING_PANE);		
		DIALOG.setSize(DIALOG_DIMENSION);

		ActionListener closeDialogListener = new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DIALOG.setVisible(false);
				SCROLLING_PANE.stopScroll();
			}
		};

		JButton button = new JButton(GUIMediator.getStringResource("ABOUT_BUTTON_LABEL"));
		button.setToolTipText(GUIMediator.getStringResource("ABOUT_BUTTON_TIP"));
		button.addActionListener(closeDialogListener);
		JPanel buttonPanel = new BoxPanel(BoxPanel.X_AXIS);
		buttonPanel.add(Box.createHorizontalGlue());
		buttonPanel.add(SCROLL_CHECK_BOX);
		buttonPanel.add(GUIMediator.getHorizontalSeparator());
		buttonPanel.add(button);
		buttonPanel.add(Box.createHorizontalGlue());
        final Container CONTENT_PANE = DIALOG.getContentPane();
        CONTENT_PANE.setLayout(new BoxLayout(CONTENT_PANE, BoxLayout.Y_AXIS));
        CONTENT_PANE.add(topPanel);
        CONTENT_PANE.add(GUIMediator.getVerticalSeparator());
        CONTENT_PANE.add(buttonPanel);
        CONTENT_PANE.add(Box.createVerticalStrut(6));
	}

	/**
	 * Displays the "About" dialog window to the user.
	 */
	void showDialog() {
		if(GUIMediator.getAppVisible())
			DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
		else {
			DIALOG.setLocation(GUIMediator.getScreenCenterPoint(DIALOG));
		}

		if(SCROLL_CHECK_BOX.isSelected()) {
			ActionListener startTimerListener = new ActionListener() {
				public void actionPerformed(ActionEvent ae) {
				    //need to check isSelected() again,
				    //it might have changed in the past 10 seconds.
				    if(SCROLL_CHECK_BOX.isSelected()) {
				        //activate scroll timer
					    SCROLLING_PANE.startScroll();
					}
				}
			};
			
			Timer startTimer = new Timer(10000, startTimerListener);
			startTimer.setRepeats(false);			
			startTimer.start();
		}
		DIALOG.setVisible(true);
	}

	/*
	public static void main(String[] args) {
	    AboutWindow aw = new AboutWindow();
	    aw.showDialog();
	}
	*/
}
