package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.plaf.metal.*;
import javax.swing.plaf.*;
import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import java.lang.ClassLoader;

/**
 * Controls the look and feel of the application.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class LimeLookAndFeel extends MetalLookAndFeel {
	/**
	 * The constructor simply sets the color theme for the application.
	 */
	LimeLookAndFeel() {
		setCurrentTheme(new LimeTheme());
	}

	public String getDescription() {
		return "Lime Look and Feel";
	}

	public String getID() {
		return "GoLime";
	}

	public String getName() {
		return "Lime Look and Feel";
	}

	public boolean isNativeLookAndFeel() {
		return false;
	}
	
	public boolean isSupportedLookAndFeel() {
		return true;
	}

	/**
	 * Set the ui delegate classes for main component classes.
	 */
	protected void initClassDefaults(UIDefaults table) {
		super.initClassDefaults(table);
		String limePackageName = "com.limegroup.gnutella.gui.";
		table.put("ButtonUI", limePackageName + "LimeButtonUI");

		if (!CommonUtils.isMacClassic())
			table.put("ClassLoader", getClass().getClassLoader());
	}

	/**
	 * Set the finer-grained ui settings for stock component ui items.
	 */
	protected void initComponentDefaults(UIDefaults table) {
		super.initComponentDefaults(table);

		Icon questionIcon  = ResourceManager.getThemeImage("question.gif");
		Icon errorIcon     = ResourceManager.getThemeImage("warning.gif");	
		Icon infoIcon      = ResourceManager.getThemeImage("notsearching.gif");
		Icon openDirIcon   = ResourceManager.getThemeImage("dir_open.gif");
		Icon closedDirIcon = ResourceManager.getThemeImage("dir_closed.gif");
		
		table.put("CheckBox.foreground", getSystemTextColor());		

		table.put("OptionPane.questionIcon", questionIcon);
		table.put("OptionPane.errorIcon", errorIcon);
		table.put("OptionPane.informationIcon", infoIcon);
		
		table.put("Table.foreground", getUserTextColor());
		table.put("Table.selectionForeground", getUserTextColor());
		table.put("Table.selectionBackground", 
            new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));
		table.put("Table.focusCellForeground", getUserTextColor());
		table.put("Table.focusCellBackground", 
			new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));

		table.put("TableHeader.background",
			new ColorUIResource(
			    ThemeFileHandler.TABLE_HEADER_BACKGROUND_COLOR.getValue()));
		table.put("TableHeader.cellBorder",
		    new BorderUIResource(BorderFactory.createRaisedBevelBorder()));
		table.put("TableHeader.cellPressedBorder",
		    new BorderUIResource(BorderFactory.createLoweredBevelBorder()));
		    
		table.put("TextField.background",
			// Note: also used for WindowTitleInactiveForeground
		    new ColorUIResource(ThemeFileHandler.WINDOW7_COLOR.getValue()));		    
		        
		table.put("ToolTip.foreground", getControlTextColor());
		table.put("ToolTip.background", getControl());

		table.put("Tree.foreground", getUserTextColor());
		table.put("Tree.expandedIcon", openDirIcon);
		table.put("Tree.collapsedIcon", closedDirIcon);
		table.put("Tree.rightChildIndent", new Integer(6));
		table.put("Tree.selectionForeground", getUserTextColor());
		table.put("Tree.selectionBackground", 
		    new ColorUIResource(ThemeFileHandler.SECONDARY3_COLOR.getValue()));

		String os = System.getProperty("os.name");
		if (!os.startsWith("Windows")) {
			FontUIResource osFont =
				new FontUIResource("Dialog", Font.PLAIN, 11);
			table.put("Label.font", osFont);
			table.put("Button.font", osFont);

		}
	}
	    
}
