package com.limegroup.gnutella.gui;

import javax.swing.*;
import java.awt.*;
import javax.swing.plaf.basic.BasicToolTipUI;

/**
 * A new class to allow mulitple lines to be displayed in a tool tip
 * @author Sumeet Thadani
 */


public class MultilineToolTipUI extends BasicToolTipUI {

    private final int blankSpace=2;//2 pixels between text &  border of tooltip

    private static MultilineToolTipUI instance = new MultilineToolTipUI();
    
    public static MultilineToolTipUI instance(){
        return instance;
    }
    
    //private constructor
    private MultilineToolTipUI(){}

    public Dimension getPreferredSize(JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics =
                             Toolkit.getDefaultToolkit().getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        String[] lines = ((JMultilineToolTip)c).getTipArray();
        if(lines == null)
            return new Dimension(0,0);
        int num_lines = lines.length;
        int height = num_lines * fontHeight;
        int width = 250;//we have a hard coded with of 250 pixels
        if (height==0)
            return new Dimension(0,0);
        return new Dimension(width+blankSpace*2,height+blankSpace*2);
    }
    
    public Dimension getMinimumSize(JComponent c) {
        return getPreferredSize(c);
    }
    
    public Dimension getMaximumSize(JComponent c) {
        return getPreferredSize(c);
    }
    
    public void paint(Graphics g, JComponent c) {
        Font font = c.getFont();
        FontMetrics fontMetrics =
        Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = c.getSize();
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        String[] lines = ((JMultilineToolTip)c).getTipArray();
        // possible NPE
        if (lines == null) return;
        int num_lines = lines.length;
        int height;
        int i;
        
        g.setColor(c.getBackground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(c.getForeground());
        for (i=0, height=2+fontAscent; i<num_lines; i++, height+=fontHeight) {
            g.drawString(lines[i], blankSpace, height);
        }        
    }
}
    
