package com.limegroup.gnutella.gui.library;

import java.awt.Color;
import java.awt.event.ActionListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;

/**
 * Constructs the primary elements of the library and provides access
 * to the <tt>Component</tt> that contains all of the elements of the
 * library.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class LibraryConstructor {

	/**
	 * The primary panel that contains all of the library elements.
	 */
	private final PaddedPanel MAIN_PANEL = new PaddedPanel();

	/**
	 * Constant for the mouse listener used to detect drag and drop events
	 * as well as double-clicks, etc.
	 */
    private final DragSourceListener MOUSE_LISTENER = 
		new DragSourceListener();

	/**
	 * Constant for the row of library buttons.
	 */
	private final ButtonRow _mainButtons;


	private final JScrollPane TREE_SCROLL_PANE;


	/**
	 * Constructs the main elements of the library and places them within
	 * the primary panel.
	 *
	 * @param libraryTable the table for the library
	 * @param libraryTree the tree controller for the library
	 */
	LibraryConstructor(final LibraryTableMediator libraryTable, 
					   final LibraryTree libraryTree) {

		String libraryTitle = 
		    GUIMediator.getStringResource("LIBRARY_TITLE");
		MAIN_PANEL.setTitle(libraryTitle);

		libraryTable.addMouseInputListener(MOUSE_LISTENER);
        TREE_SCROLL_PANE = new JScrollPane(libraryTree.getTree());
        Box splitBox = new Box(BoxLayout.X_AXIS);
        JSplitPane splitPane = 
		    new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,TREE_SCROLL_PANE, 
						   libraryTable.getScrolledTablePane() );
        splitPane.setDividerLocation(150);
        splitPane.setOneTouchExpandable(true);
        splitBox.add(splitPane);

  		BoxPanel buttonPanel = new BoxPanel(BoxPanel.X_AXIS);
		_mainButtons = libraryTable.getButtonRow();


        String[] refreshKey = {"LIBRARY_REFRESH_BUTTON_LABEL"};
        String[] refreshTip = {"LIBRARY_REFRESH_BUTTON_TIP"};
        ActionListener[] refreshListener = {new RefreshListener()};
		ButtonRow refreshButton = new ButtonRow(refreshKey, refreshTip, 
												refreshListener);

        String[] exploreKey = {"LIBRARY_EXPLORE_BUTTON_LABEL"};
        String[] exploreTip = {"LIBRARY_EXPLORE_BUTTON_TIP"};
        ActionListener[] exploreListener = {new ExploreListener()};
		ButtonRow exploreButton = new ButtonRow(exploreKey, exploreTip, 
												exploreListener);


  		buttonPanel.add(_mainButtons);
        buttonPanel.add(Box.createHorizontalStrut(GUIConstants.SEPARATOR*3));
		JPanel p = new JPanel();
		p.add(refreshButton);
	    if(CommonUtils.isWindows() || CommonUtils.isMacOSX()) 	
		    p.add(exploreButton);
		buttonPanel.add(p);

        MAIN_PANEL.add(splitBox);
		MAIN_PANEL.add(Box.createVerticalStrut(GUIConstants.SEPARATOR));
		MAIN_PANEL.add(buttonPanel);
		updateTheme();		
	}

	// inherit doc comment
	public void updateTheme() {
		Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
		TREE_SCROLL_PANE.getViewport().setBackground(tableColor);
	}

	/**
	 * Returns the <tt>JComponent</tt> that contains all of the elements of
	 * the library.
	 *
	 * @return the <tt>JComponent</tt> that contains all of the elements of
	 * the library
	 */
	JComponent getComponent() {
		return MAIN_PANEL;
	}
}
