package com.limegroup.gnutella.gui.search;

import javax.swing.*;
import java.awt.*;

/** Simple extension of JPanel that makes a FlowLayout.LEADING JPanel that
 *  has a background image which is painted.
 */
public class DitherPanel extends JPanel {

    private final Ditherer DITHERER;
    
    /**
     * Creates a FlowLayout.LEADING layout.
     *
     * @param ditherer the <tt>Ditherer</tt> that paints the dithered 
	 *  background
     */
    public DitherPanel(Ditherer ditherer) { 
        super(new FlowLayout(FlowLayout.LEFT));
        DITHERER = ditherer;
    }    

    /** Does the actual placement of the background image.
     */
    public void paintComponent(java.awt.Graphics g) {
        super.paintComponent(g);  //TODO: needed?
        DITHERER.draw(g, getSize().height, getSize().width);
    }
}



