package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*;
import java.awt.*;


/**
 * Optimized class to draw vertical fades from one color to another.
 */
public final class Ditherer implements ThemeObserver {
    private int _redT;
    private int _greenT;
    private int _blueT;

    private int _redB;
    private int _greenB;
    private int _blueB;

    private int _steps;

    /** 
     * Constructs a new ditherer that will fade from top to bottom vertically.
     */
    Ditherer() { 
		updateTheme();
        _steps = SearchInputManager.FADE_STEPS;
    }

	// inherit doc comment
	public void updateTheme() {
		Color backColor = SearchInputManager._backColor;
        _redT   = backColor.getRed();
        _greenT = backColor.getGreen();
        _blueT  = backColor.getBlue();

		Color fadeColor = SearchInputManager._fadeColor;
        _redB   = fadeColor.getRed();
        _greenB = fadeColor.getGreen();
        _blueB  = fadeColor.getBlue();
	}

    /** 
     * Draws the requested fade to g, with the given width and height.
     */
    public void draw(final java.awt.Graphics g, final int height, final int width) {
        final float redStep=(float)(_redB-_redT)/(float)_steps;    
        final float greenStep=(float)(_greenB-_greenT)/(float)_steps;
        final float blueStep=(float)(_blueB-_blueT)/(float)_steps;
        float red=(float)_redT;
        float green=(float)_greenT;
        float blue=(float)_blueT;

        final int yStep=height/_steps;   //rounds down
        int y=0;

        //Draw a rectangle for each step
        for (int i=0; i<_steps; i++) {
            Color c=new Color(round(red), round(green), round(blue));
            g.setColor(c);
            g.fillRect(0, y, width, yStep);

            y+=yStep;
            red+=redStep;
            green+=greenStep;
            blue+=blueStep;
        }
        
        //Ensure bottom is filled.
        Color c=new Color(round(red), round(green), round(blue));
        g.setColor(c);
        g.fillRect(0, y, width, height-y);
    }

    private static int round(float color) {
        int ret=Math.round(color);
        if (ret<0)
            return 0;
        if (ret>255)
            return 255;
        else
            return ret;
    }
}
