package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.*;
import javax.swing.border.*;
import javax.swing.*;
import java.awt.*;
import javax.swing.table.*;

/**
 * This class handles rendering the "Quality" column in the search results.
 * It uses different labels depending on how many stars should be displayed.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class QualityRenderer implements TableCellRenderer, ThemeObserver {

	/**
	 * The default border to use -- used when the label does not have focus.
	 */
    private static Border _noFocusBorder = new EmptyBorder(1, 1, 1, 1); 

	/**
	 * Holder for the foreground color to use when a label is not selected.
	 */
    private Color _unselectedForeground; 

	/**
	 * Holder for the background color to use when a label is not selected.
	 */
    private Color _unselectedBackground; 

	/**
	 * <tt>JLabel</tt> instance for rendering one star.
	 */
	private final JLabel STAR_ONE = new JLabel();

	/**
	 * <tt>JLabel</tt> instance for rendering two stars.
	 */
	private final JLabel STAR_TWO = new JLabel();

	/**
	 * <tt>JLabel</tt> instance for rendering three stars.
	 */
	private final JLabel STAR_THREE = new JLabel();

	/**
	 * <tt>JLabel</tt> instance for rendering four stars.
	 */
	private final JLabel STAR_FOUR = new JLabel();
	
	/**
	 * <tt>JLabel</tt> instance for rendering five stars.
	 */
	private final JLabel STAR_FIVE = new JLabel();

	
	/**
	 * <tt>JLabel</tt> handle to the current label in use.
	 */
	private JLabel _curLabel = STAR_ONE;

	/**
	 * Makes all of the star labels opaque and sets their borders.
	 */
	QualityRenderer() {
		STAR_ONE.setOpaque(true);
		STAR_TWO.setOpaque(true);
		STAR_THREE.setOpaque(true);
		STAR_FOUR.setOpaque(true);
		STAR_FIVE.setOpaque(true);		

		STAR_ONE.setBorder(_noFocusBorder);
		STAR_TWO.setBorder(_noFocusBorder);
		STAR_THREE.setBorder(_noFocusBorder);
		STAR_FOUR.setBorder(_noFocusBorder);
		STAR_FIVE.setBorder(_noFocusBorder);
		updateTheme();
		GUIMediator.addThemeObserver(this);
	}

	// inherit doc comment
	public void updateTheme() {
		STAR_ONE.setIcon(GUIMediator.getThemeImage("01_star.gif"));
		STAR_TWO.setIcon(GUIMediator.getThemeImage("02_star.gif"));
		STAR_THREE.setIcon(GUIMediator.getThemeImage("03_star.gif"));
		STAR_FOUR.setIcon(GUIMediator.getThemeImage("04_star.gif"));
		STAR_FIVE.setIcon(GUIMediator.getThemeImage("05_star.gif"));
	}

	/**
	 * Returns the <tt>Component</tt> that displays the stars based
	 * on the number of stars in the <tt>QualityHolder</tt> object.
	 */
	public Component getTableCellRendererComponent
		(JTable table,Object value,boolean isSelected,
		 boolean hasFocus,int row,int column) {
		if(value == null) {
			throw new NullPointerException("Null value in QualityRenderer");
		}
		int numStars = ((Integer)value).intValue();;
		
		if (numStars == 4) {
		    _curLabel = STAR_FIVE;
		} else if (numStars == 3) {
			_curLabel = STAR_FOUR;
		} else if (numStars == 2) {
			_curLabel = STAR_THREE;
		} else if (numStars == 1) {
			_curLabel = STAR_TWO;
		} else {
			_curLabel = STAR_ONE;
		}

		if (isSelected) {
			_curLabel.setForeground(table.getSelectionForeground());
			_curLabel.setBackground(table.getSelectionBackground());
		}
		else {
			_curLabel.setForeground((_unselectedForeground != null) ? 
									_unselectedForeground 
									: table.getForeground());
			_curLabel.setBackground((_unselectedBackground != null) ? 
									_unselectedBackground 
									: table.getBackground());
		}
		return _curLabel;		
	}

}
