package com.limegroup.gnutella.gui.search;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * This class handles mouse input to the search tabbed pane.
 */
//2345678|012345678|012345678|012345678|012345678|012345678|012345678|012345678|
final class TabbedPaneMouseListener implements MouseListener {
	
    /**
     * Invoked when the mouse has been clicked on a component.
     */
    public void mouseClicked(MouseEvent me) {
		if(me.isPopupTrigger() || SwingUtilities.isRightMouseButton(me)) {
			SearchMediator.showMenu((Component)me.getSource(), 
									me.getX(), me.getY());
		}
	}

    /**
     * Invoked when a mouse button has been pressed on a component.
     */
    public void mousePressed(MouseEvent me) {
		if(me.isPopupTrigger() || SwingUtilities.isRightMouseButton(me)) {
			SearchMediator.showMenu((Component)me.getSource(), 
									me.getX(), me.getY());
		}
    }

    /**
     * Invoked when a mouse button has been released on a component.
	 * Checks to see if the Icon object for the selected tab has been
	 * clicked, canceling the search if it has.
     */
    public void mouseReleased(MouseEvent e) {
        if(!SwingUtilities.isLeftMouseButton(e) )
            return;

		Icon icon = SearchMediator.getSelectedIcon();
		if(icon == null) return;
		int x = e.getX();
		int y = e.getY();
		if(((CancelSearchIconProxy)icon).shouldKill(x,y)) {
			SearchMediator.killSearch();                    
		}
	}

    /**
     * Invoked when the mouse enters a component.
     */
    public void mouseEntered(MouseEvent e) {}

    /**
     * Invoked when the mouse exits a component.
     */
    public void mouseExited(MouseEvent e) {}
}
