/*
=====================================================================

  SortHeaderRenderer.java
  
  Created by Claude Duguay
  Copyright (c) 2002

  Taken freely from:
   http://www.fawcette.com/javapro/2002_08/magazine/columns/visualcomponents/
   at the 'download code' link.
   
  Slightly modified for use with interface JSortTable
  and 'pressed' looks.
  
=====================================================================
*/

package com.limegroup.gnutella.gui.tables;

import java.awt.*;
import javax.swing.*;
import javax.swing.table.*;
import javax.swing.border.*;

public final class SortHeaderRenderer extends DefaultTableCellRenderer {
    public static Icon ASCENDING = new SortArrowIcon(SortArrowIcon.ASCENDING);
    public static Icon DECENDING = new SortArrowIcon(SortArrowIcon.DESCENDING);
    
    public SortHeaderRenderer() {
        setHorizontalAlignment(CENTER);
        setIconTextGap(2); // reduce from the default of 4 pixels
        setHorizontalTextPosition(LEFT);
    }
    
    public Component getTableCellRendererComponent( JTable table,
     Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        int index = -1;
        boolean ascending = true;
        boolean isPressed = false;
        if (table instanceof JSortTable) {
            JSortTable sortTable = (JSortTable)table;
            index = sortTable.getSortedColumnIndex();
            ascending = sortTable.isSortedColumnAscending();
            isPressed = (sortTable.getPressedColumnIndex() == col);
        }
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                setForeground(header.getForeground());
                setBackground(header.getBackground());
                setFont(header.getFont());
            }
        }
        
        Icon icon = (col == index) ? (ascending ? ASCENDING : DECENDING) : null;
        setIcon(icon);
        setText((value == null) ? null : value.toString());
        
        if ( isPressed ) {
            // need to explicitly check for cellPressedBorder since some laf's
            // [osx] might not have it.  all will have cellBorder tho.
            Border bd = UIManager.getBorder("TableHeader.cellPressedBorder");
            if(bd == null) bd = UIManager.getBorder("TableHeader.cellBorder");
            setBorder(bd);
        }
        else
            setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }
}

