/****************************************************************************
**
** $Id: MergeDialogImpl.h,v 1.13 2004/01/11 22:25:04 riemer Exp $
**
** Copyright (C) 2001-2004 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Frank Hemer <frank@hemer.org>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Tom Mishima <tmishima@mail.at-m.or.jp>
**    Joerg Preiss <auba@auba.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#ifndef MERGEDIALOGIMPL_H_20011101
#define MERGEDIALOGIMPL_H_20011101

#include "config.h"

#include <qiconset.h>

#include "globals.h"
#include "MergeDialog.h"

class MergeDialogImpl : public MergeDialog
{ 
  Q_OBJECT

signals:
  void getSelectedTags();
  void getProjectTags();

public slots:
  void tagListUpdated();
  void enterWhatsThisMode();

public:
  MergeDialogImpl (const QIconSet &whatsThisIconSet,
		   QWidget* parent, const char* name, QStringList *list,
		   QString moduleName, bool modal = FALSE, WFlags fl = 0 );
  ~MergeDialogImpl();
  QSize sizeHint () const;
  void hideQueryNUpdateDirs();

 private slots:
  void okClicked();
  void fetchClicked();
  void setSelectionFirstTag();
  void setSelectionSecondTag();
  void activatedFirstTag(const QString &);
  void activatedSecondTag(const QString &);
  void textChangedFirstTag(const QString &);
  void textChangedSecondTag(const QString &);
  void updateSize();

 private:
  void readProjectNameList();
  void setPixmaps(QComboBox *);

  QStringList * m_pSelectedTagList;
  QString m_topModuleName;
  bool m_fetchOverall;
  bool m_firstTagListOnEdit;
  bool m_secondTagListOnEdit;
  QPixmap * m_pOldFirstTagPixmap;
  QPixmap * m_pOldSecondTagPixmap;

  QStringList m_ProjectTagList;
  int m_oldFirstTagIdx;
  int m_oldSecondTagIdx;
  bool m_firstTagListOnUpdate;
  bool m_secondTagListOnUpdate;
  QString m_oldFirstTagText;
  QString m_oldSecondTagText;
  int m_lastFirstTagLen;
  int m_lastSecondTagLen;
};


#endif //MERGEDIALOGIMPL_H_20011101


