/****************************************************************************
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org>,
 **                         Frank Hemer <frank@hemer.org>,
 **                         Jose Hernandez <joseh@tesco.net> and
 **                         Joerg Preiss <auba@auba.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:

 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/


#ifndef CVSLIB_CVSCONFIG
#define CVSLIB_CVSCONFIG

//----------------------------------------------------------------------------

#include "config.h"

//----------------------------------------------------------------------------

#include <qrect.h>
#include <qsettings.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qmessagebox.h>
#include <qcolor.h>

//----------------------------------------------------------------------------

#include "globals.h"
#include "TextCodec.h"

//----------------------------------------------------------------------------


/*!	This class implements all configurable Items of lincvs.
  \brief Configuration class.
*/
class CvsConfig
{
   static const char Version[];
   static const char Debug[];
   static const char LogLevel[];
   static const char CheckStatusIntervall[];
   static const char CheckStatusLevel[];
   static const char ProgressIntervall[];

   static const char AutoUpdate[];
   static const char AutoUpdateIntervall[];

   static const char cvsPassFile[];
   static const char cvsPath[];
   static const char cvsVersion[];
   static const char useDirWatch[];

   static const char DirPopupMenu[];
   static const char FilePopupMenu[];
   static const char KeyboarsShortcuts[];
   static const char OpenFileList[];
   static const char ViewFileList[];
   static const char ScanOnTheFly[];
   static const char ScanNonCvs[];
   static const char CvsIgnoreFiles[];
   static const char UseExternalDiff[];
   static const char ExtDiffProgram[];
   static const char IconDir[];
   static const char ColorRevA[];
   static const char ColorRevB[];
   static const char UseStandardDialogs[];
   static const char DateTimeOrder[];
   static const char DateTimeFormat[];
   static const char Use0AsParent[];
   static const char TopLevelWidget[];
   
   static const char GeomX[];
   static const char GeomY[];
   static const char GeomWidth[];
   static const char GeomHeight[];
   static const char SplitterPosH[];
   static const char SplitterPosV[];
   static const char WorkbenchColumnWidth[];
   static const char ToolbarPos[];
   static const char FileHeaderPos[];

   static const char Compression[];
   static const char RwPermission[];
   static const char VirtualInFiletab[];
   static const char DiffPrecision[];
   static const char UnifiedDiffOutput[];

   static const char PruneDirs[];
   static const char BringOverNewDirs[];
   static const char KeywordSuppression[];
   static const char IgnoreWhiteSpace[];
   static const char HistoryPeriod[];
   static const char Quiet[];

   static const char SshKeyList[];
   static const char SshAgent[];
   static const char RemoteBrowser[];
   static const char LocalBrowser[];
   static const char CVSRsh[];
   static const char LocalShell[];

   static const char UserList[];
   static const char ServerList[];
   static const char RepositoryList[];
   static const char ProfileList[];
   static const char XProfileList[];
   static const char ModuleList[];
   static const char WorkdirList[];
   static const char CheckoutAsList[];
   static const char ProxyList[];
   static const char BinaryFileSpecList[];

   static const char HistSizeComments[];
   static const char HistSizeWorkdirs[];
   static const char HistSizeProfiles[];

   static const char Projects[];

   //Syntax highlighting of messagewidget
   static const char UseSyntaxHighlight[];
   static const char SynHighQuestionMarkStyle[];
   static const char SynHighQuestionMarkRgb[];
   static const char SynHighModifiedStyle[];
   static const char SynHighModifiedRgb[];
   static const char SynHighNeedsUpdateStyle[];
   static const char SynHighNeedsUpdateRgb[];
   static const char SynHighMergingStyle[];
   static const char SynHighMergingRgb[];
   static const char SynHighConflictStyle[];
   static const char SynHighConflictRgb[];
   static const char SynHighAddedStyle[];
   static const char SynHighAddedRgb[];
   static const char SynHighRemovedStyle[];
   static const char SynHighRemovedRgb[];
   static const char SynHighRemovedByOtherStyle[];
   static const char SynHighRemovedByOtherRgb[];
   static const char SynHighDiffOldStyle[];
   static const char SynHighDiffOldRgb[];
   static const char SynHighDiffNewStyle[];
   static const char SynHighDiffNewRgb[];

   //fonts
   static const char FontGeneral[];
   static const char FontMessage[];
   static const char FontDiff[];

   //i18n
   static const char TextEncoder[];
   static const char TextDecoder[];
   
   //defaults
   static const char defCvsVersion[];
   static const char defSshAgent[];
   static const char defRemoteBrowser[];
   static const char defLocalBrowser[];
   static const char defCvsRsh[];
   static const char defLocalShell[];
   static const char defCvsIgnoreFiles[];
   static const char defKeyboarsShortcuts[];
   static const char defOpenFileList[];
   static const char defViewFileList[];

      
 public:
   CvsConfig();
   ~CvsConfig();


   void readCfg();
   void writeCfg();

   bool debug() {
      return m_pSettings->readBoolEntry(Debug, false);
   }
   void setDebug(bool dbg) {
      m_pSettings->writeEntry(Debug, dbg);
   }
   Debug::LogLevel logLevel() {
      switch (m_pSettings->readNumEntry(LogLevel, 0)) {
	 case 0:  return Debug::LL_LIKE_A_FISH;
	 case 1:  return Debug::LL_THE_OLD_MAN_AND_THE_SEA;
	 case 2:  return Debug::LL_INFO;
	 case 3:  return Debug::LL_DEBUG;
	 case 4:  return Debug::LL_GOSSIP_MONGER;
	 default: return Debug::LL_LIKE_A_FISH;
      }
   }
   bool setLogLevel(int level) {
      return m_pSettings->writeEntry(LogLevel, level);
   }
   QString getCvsPassPath() {
      return m_pSettings->readEntry(cvsPassFile, CVSPASSPATH);
   }
   void setCvsPassPath(QString& file) {
      m_pSettings->writeEntry(cvsPassFile,file);
   }
   QString getCvsPath() {
      return m_pSettings->readEntry(cvsPath, "");
   }
   void setCvsPath(QString& path) {
      m_pSettings->writeEntry(cvsPath,path);
   }
   QString getCvsVersion() {
      return m_pSettings->readEntry(cvsVersion, defCvsVersion);
   }
   void setCvsVersion(QString& version) {
      m_pSettings->writeEntry(cvsVersion,version);
   }
   bool getUseDirWatch() {
      return m_pSettings->readBoolEntry(useDirWatch, false);
   }
   void setUseDirWatch(bool state) {
      m_pSettings->writeEntry(useDirWatch,state);
   }
   long checkStatusIntervall() {
      return m_pSettings->readNumEntry(CheckStatusIntervall, 3000L);
   }
   bool setCheckStatusIntervall(int val) {
      return m_pSettings->writeEntry(CheckStatusIntervall, val);
   }
   int getCheckStatusLevel() {
      return m_pSettings->readNumEntry(CheckStatusLevel, 1);
   }
   bool setCheckStatusLevel(int val) {
      return m_pSettings->writeEntry(CheckStatusLevel, val);
   }
   long progressIntervall() {
      return m_pSettings->readNumEntry(ProgressIntervall, 117L);
   }
   bool setProgressIntervall(int val) {
      return m_pSettings->writeEntry(ProgressIntervall, val);
   }
   bool getAutoUpdate() {
      return m_pSettings->readBoolEntry(AutoUpdate, false);
   }
   bool setAutoUpdate(bool val) {
      return m_pSettings->writeEntry(AutoUpdate, val);
   }
   long getAutoUpdateIntervall() {
      return m_pSettings->readNumEntry(AutoUpdateIntervall, 30L);
   }
   bool setAutoUpdateIntervall(int val) {
      return m_pSettings->writeEntry(AutoUpdateIntervall, val);
   }
   int splitterPosH() {
      return m_pSettings->readNumEntry(SplitterPosH, 150);
   }
   void setSplitterPosH(int val) {
      m_pSettings->writeEntry(SplitterPosH, val);
   }
   int splitterPosV() {
      return m_pSettings->readNumEntry(SplitterPosV, 150);
   }
   void setSplitterPosV(int val) {
      m_pSettings->writeEntry(SplitterPosV, val);
   }
   int workbenchColumnWidth() {
      return m_pSettings->readNumEntry(WorkbenchColumnWidth, 150);
   }
   void setWorkbenchColumnWidth(int val) {
      m_pSettings->writeEntry(WorkbenchColumnWidth, val);
   }
   QString getToolbarPos() {
      return m_pSettings->readEntry(ToolbarPos, "");
   }
   void setToolbarPos(const QString& fhpos) {
      m_pSettings->writeEntry(ToolbarPos, fhpos);
   }
   QString getFileHeaderPos() {
      return m_pSettings->readEntry(FileHeaderPos, "");
   }
   void setFileHeaderPos(const QString& tbpos) {
      m_pSettings->writeEntry(FileHeaderPos, tbpos);
   }
	
   int compression() {
      return m_pSettings->readNumEntry(Compression, 0);
   }
   void setCompression(int val) {
      if( val < 0 ) val = 0;   //0 means no compression
      if( val > 9 ) val = 9;
      m_pSettings->writeEntry(Compression, val);
   }
   bool rwPermission() {
      return m_pSettings->readBoolEntry(RwPermission, true);
   }
   void setRwPermission(bool permission) {
      m_pSettings->writeEntry(RwPermission, permission);
   }
   bool getShowVirtualInFiletab() {
      return m_pSettings->readBoolEntry(VirtualInFiletab, true);
   }
   void setShowVirtualInFiletab(bool state) {
      m_pSettings->writeEntry(VirtualInFiletab, state);
   }
   int getDiffPrecision() {
      return m_pSettings->readNumEntry(DiffPrecision,2);
   }
   void setDiffPrecision(int val) {
      m_pSettings->writeEntry(DiffPrecision,val);
   }
   bool getUnifiedDiffOutput() {
      return m_pSettings->readBoolEntry(UnifiedDiffOutput, true);
   }
   void setUnifiedDiffOutput(bool state) {
      m_pSettings->writeEntry(UnifiedDiffOutput, state);
   }
   bool pruneDirs() {
      return m_pSettings->readBoolEntry(PruneDirs, true);
   }
   void setPruneDirs(bool bPrune) {
      m_pSettings->writeEntry(PruneDirs, bPrune);
   }
   bool bringOverNewDirs() {
      return m_pSettings->readBoolEntry(BringOverNewDirs, true);
   }
   void setBringOverNewDirs(bool bBringOver) {
      m_pSettings->writeEntry(BringOverNewDirs, bBringOver);
   }
   bool keywordSuppression() {
      return m_pSettings->readBoolEntry(KeywordSuppression, true);
   }
   void setKeywordSuppression(bool bSupp) {
      m_pSettings->writeEntry(KeywordSuppression, bSupp);
   }
   bool getIgnoreWhiteSpace() {
      return m_pSettings->readBoolEntry(IgnoreWhiteSpace, false);
   }
   void setIgnoreWhiteSpace(bool bWS) {
      m_pSettings->writeEntry(IgnoreWhiteSpace, bWS);
   }
   int getHistoryPeriod() {
      return m_pSettings->readNumEntry(HistoryPeriod, -1);
   }
   void setHistoryPeriod(int period) {
      m_pSettings->writeEntry(HistoryPeriod, period);
   }
   bool getQuiet() {
      return m_pSettings->readBoolEntry(Quiet, false);
   }
   void setQuiet(bool bQuiet) {
      m_pSettings->writeEntry(Quiet, bQuiet);
   }

   bool useExtDiff() {
      return m_pSettings->readBoolEntry(UseExternalDiff, false);
   }
   void setUseExtDiff(bool useIt) {
      m_pSettings->writeEntry(UseExternalDiff, useIt);
   }
   QStringList getSshKeyList() {
      QStringList list = m_pSettings->readListEntry(SshKeyList);
      return list;
   }
   void setSshKeyList(QStringList list) {
      m_pSettings->writeEntry(SshKeyList,list);
   }
   QString sshAgent() {
      return m_pSettings->readEntry(SshAgent, defSshAgent);
   }
   void setSshAgent(const QString& prog) {
      m_pSettings->writeEntry(SshAgent, prog);
   }
   QString extDiffProgram() {
      return m_pSettings->readEntry(ExtDiffProgram, "");
   }
   void setExtDiffProgram(const QString& prog) {
      m_pSettings->writeEntry(ExtDiffProgram, prog);
   }
   QString localBrowser() {
      return m_pSettings->readEntry(LocalBrowser, defLocalBrowser);
   }
   void setLocalBrowser(const QString& cmd) {
      m_pSettings->writeEntry(LocalBrowser, cmd);
   }
   QString remoteBrowser() {
      return m_pSettings->readEntry(RemoteBrowser, defRemoteBrowser);
   }
   void setRemoteBrowser(const QString& cmd) {
      m_pSettings->writeEntry(RemoteBrowser, cmd);
   }
   QString localShell() {
      return m_pSettings->readEntry(LocalShell, defLocalShell);
   }
   void setLocalShell(const QString& cmd) {
      m_pSettings->writeEntry(LocalShell, cmd);
   }
   QString CvsRsh() {
      return m_pSettings->readEntry(CVSRsh, defCvsRsh);
   }
   void setCvsRsh(const QString& cmd) {
      m_pSettings->writeEntry(CVSRsh, cmd);
   }
   QRect geometry() {
      return QRect(geomX(), geomY(), geomWidth(), geomHeight());
   }
   void setGeometry(const QRect& rect) {
      setGeomX(rect.x());
      setGeomY(rect.y());
      setGeomWidth(rect.width());
      setGeomHeight(rect.height());
   }
   QString dirPopupMenu() {
      return m_pSettings->readEntry(DirPopupMenu, DEFDIRPOPUPMENU);
   }
   void setDirPopupMenu(const QString& items) {
      m_pSettings->writeEntry(DirPopupMenu, items);
   }
   QString filePopupMenu() {
      return m_pSettings->readEntry(FilePopupMenu, DEFFILEPOPUPMENU);
   }
   void setFilePopupMenu(const QString& items) {
      m_pSettings->writeEntry(FilePopupMenu, items);
   }
   QString getKeyboardShortcuts() {
      return m_pSettings->readEntry(KeyboarsShortcuts,defKeyboarsShortcuts);
   }
   void setKeyboardShortcuts(const QString& shortcuts) {
      m_pSettings->writeEntry(KeyboarsShortcuts,shortcuts);
   }
   QStringList getOpenFileList() {
      QStringList list = m_pSettings->readListEntry(OpenFileList);
      if (list.count() == 0) list.append(defOpenFileList);
      return list;
   }
   void setOpenFileList(QStringList list) {
      m_pSettings->writeEntry(OpenFileList,list);
   }
   QStringList getViewFileList() {
      QStringList list = m_pSettings->readListEntry(ViewFileList);
      if (list.count() == 0) list.append(defViewFileList);
      return list;
   }
   void setViewFileList(QStringList list) {
      m_pSettings->writeEntry(ViewFileList,list);
   }
   bool getOnTheFlyScanning() {
      return m_pSettings->readBoolEntry(ScanOnTheFly, false);
   }
   void setOnTheFlyScanning(bool scanmode) {
      m_pSettings->writeEntry(ScanOnTheFly, scanmode);
   }
   bool getScanNonCvs() {
      return m_pSettings->readBoolEntry(ScanNonCvs, true);
   }
   void setScanNonCvs(bool scanmode) {
      m_pSettings->writeEntry(ScanNonCvs, scanmode);
   }
   QString cvsIgnoreFiles() {
      return m_pSettings->readEntry(CvsIgnoreFiles, defCvsIgnoreFiles);
   }
   void setCvsIgnoreFiles(const QString& ignore) {
      m_pSettings->writeEntry(CvsIgnoreFiles, ignore);
   }
   QString iconDirectory() {
      return m_pSettings->readEntry(IconDir, "");
   }
   void setIconDirectory(const QString& dir) {
      m_pSettings->writeEntry(IconDir, dir);
   }

   int colorRev(bool bRevARevB_01) {//false: RevA; true: RevB
      if (bRevARevB_01) {
         return m_pSettings->readNumEntry(ColorRevA, 0x00ff0000L);
      } else {
         return m_pSettings->readNumEntry(ColorRevB, 0x0000ff00L);
      }
   }
   void setColorRev(bool bRevARevB_01, int val) {
      if (bRevARevB_01) {
         m_pSettings->writeEntry(ColorRevA, val);
      } else {
         m_pSettings->writeEntry(ColorRevB, val);
      }
   }

   bool getStdDlg() {
      return m_pSettings->readBoolEntry(UseStandardDialogs, true);
   }
   void setStdDlg(bool state) {
      m_pSettings->writeEntry(UseStandardDialogs,state);
   }
   int getDateTimeOrder() {
      return m_pSettings->readNumEntry(DateTimeOrder, QDateEdit().order());
   }
   void setDateTimeOrder( QDateEdit::Order order) {
      m_pSettings->writeEntry(DateTimeOrder,order);
   }
   QString getDateTimeFormat() {
      return m_pSettings->readEntry(DateTimeFormat, "yyyy/MM/dd hh:mm:ss");
   }
   void setDateTimeFormat( QString format) {
      m_pSettings->writeEntry(DateTimeFormat,format);
   }
   bool get0AsParent() {
#ifdef Q_WS_WIN
      return m_pSettings->readBoolEntry(Use0AsParent, false);
#else
      return m_pSettings->readBoolEntry(Use0AsParent, true);
#endif
   }
   void set0AsParent(bool state) {
      m_pSettings->writeEntry(Use0AsParent,state);
   }
   bool getTopLevelW() {
      return m_pSettings->readBoolEntry(TopLevelWidget, true);
   }
   void setTopLevelW(bool state) {
      m_pSettings->writeEntry(TopLevelWidget,state);
   }
   unsigned int historySizeComments() {
      return m_pSettings->readNumEntry(HistSizeComments, 20);
   }
   void setHistorySizeComments(int size) {
      m_pSettings->writeEntry(HistSizeComments, size);
   }
   unsigned int historySizeWorkdirs() {
      return m_pSettings->readNumEntry(HistSizeWorkdirs, 20);
   }
   void setHistorySizeWorkdirs(int size) {
      m_pSettings->writeEntry(HistSizeWorkdirs, size);
   }
   unsigned int historySizeProfiles() {
      return m_pSettings->readNumEntry(HistSizeProfiles, 20);
   }
   void setHistorySizeProfiles(int size) {
      m_pSettings->writeEntry(HistSizeProfiles, size);
   }
   QStringList userList() {
      return m_pSettings->readListEntry(UserList);
   }   
   void setUserList(const QStringList& l) {
      m_pSettings->writeEntry(UserList, l);
   }
   QStringList serverList() {
      return m_pSettings->readListEntry(ServerList);
   }   
   void setServerList(const QStringList& l) {
      m_pSettings->writeEntry(ServerList, l);
   }
   QStringList repositoryList() {
      return m_pSettings->readListEntry(RepositoryList);
   }   
   void setRepositoryList(const QStringList& l) {
      m_pSettings->writeEntry(RepositoryList, l);
   }
   QStringList profileList() {
      return m_pSettings->readListEntry(ProfileList);
   }   
   void setProfileList(const QStringList& l) {
      m_pSettings->writeEntry(ProfileList, l);
   }
   QStringList xprofileList() {
      return m_pSettings->readListEntry(XProfileList);
   }   
   void setxProfileList(const QStringList& l) {
      m_pSettings->writeEntry(XProfileList, l);
   }
   QStringList moduleList() {
      return m_pSettings->readListEntry(ModuleList);
   }   
   void setModuleList(const QStringList& l) {
      m_pSettings->writeEntry(ModuleList, l);
   }
   QStringList workdirList() {
      return m_pSettings->readListEntry(WorkdirList);
   }   
   void setWorkdirList(const QStringList& l) {
      m_pSettings->writeEntry(WorkdirList, l);
   }
   QStringList getCheckoutAsList() {
      return m_pSettings->readListEntry(CheckoutAsList);
   }   
   void setCheckoutAsList(const QStringList& l) {
      m_pSettings->writeEntry(CheckoutAsList, l);
   }
   QStringList getProxyList() {
      return m_pSettings->readListEntry(ProxyList);
   }   
   void setProxyList(const QStringList& l) {
      m_pSettings->writeEntry(ProxyList, l);
   }
   QStringList getBinaryFileSpecList() {
      return m_pSettings->readListEntry(BinaryFileSpecList);
   }   
   void setBinaryFileSpecList(const QStringList& l) {
      m_pSettings->writeEntry(BinaryFileSpecList, l);
   }

   //syntax highlighting   
   bool getUseSyntaxHighlighting() {
      return m_pSettings->readBoolEntry(UseSyntaxHighlight, true);
   }
   void setUseSyntaxHighlighting(bool bUse) {
      m_pSettings->writeEntry(UseSyntaxHighlight, bUse);
   }
   HighlightProperties::FontStyle getQuestionMarkStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighQuestionMarkStyle, HighlightProperties::FS_NORMAL);
   }
   void setQuestionMarkStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighQuestionMarkStyle, style);
   }
   QColor getQuestionMarkColor() {
      QColor c(Qt::gray);
      c.setRgb(m_pSettings->readNumEntry(SynHighQuestionMarkRgb, c.rgb()));
      return c;
   }
   void setQuestionMarkColor(QColor color) {
      m_pSettings->writeEntry(SynHighQuestionMarkRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getModifiedStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighModifiedStyle, HighlightProperties::FS_NORMAL);
   }
   void setModifiedStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighModifiedStyle, style);
   }
   QColor getModifiedColor() {
      QColor c(Qt::red);
      c.setRgb(m_pSettings->readNumEntry(SynHighModifiedRgb, c.rgb()));
      return c;
   }
   void setModifiedColor(QColor color) {
      m_pSettings->writeEntry(SynHighModifiedRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getNeedsUpdateStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighNeedsUpdateStyle, HighlightProperties::FS_NORMAL);
   }
   void setNeedsUpdateStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighNeedsUpdateStyle, style);
   }
   QColor getNeedsUpdateColor() {
      QColor c(Qt::blue);
      c.setRgb(m_pSettings->readNumEntry(SynHighNeedsUpdateRgb, c.rgb()));
      return c;
   }
   void setNeedsUpdateColor(QColor color) {
      m_pSettings->writeEntry(SynHighNeedsUpdateRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getMergingStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighMergingStyle, HighlightProperties::FS_ITALIC);
   }
   void setMergingStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighMergingStyle, style);
   }
   QColor getMergingColor() {
      QColor c(Qt::blue);
      c.setRgb(m_pSettings->readNumEntry(SynHighMergingRgb, c.rgb()));
      return c;
   }
   void setMergingColor(QColor color) {
      m_pSettings->writeEntry(SynHighMergingRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getConflictStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighConflictStyle, HighlightProperties::FS_BOLD);
   }
   void setConflictStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighConflictStyle, style);
   }
   QColor getConflictColor() {
      QColor c(Qt::magenta);
      c.setRgb(m_pSettings->readNumEntry(SynHighConflictRgb, c.rgb()));
      return c;
   }
   void setConflictColor(QColor color) {
      m_pSettings->writeEntry(SynHighConflictRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getAddedStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighAddedStyle, HighlightProperties::FS_BOLD | HighlightProperties::FS_ITALIC);
   }
   void setAddedStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighAddedStyle, style);
   }
   QColor getAddedColor() {
      QColor c(Qt::red);
      c.setRgb(m_pSettings->readNumEntry(SynHighAddedRgb, c.rgb()));
      return c;
   }
   void setAddedColor(QColor color) {
      m_pSettings->writeEntry(SynHighAddedRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getRemovedStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighRemovedStyle, HighlightProperties::FS_NORMAL);
   }
   void setRemovedStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighRemovedStyle, style);
   }
   QColor getRemovedColor() {
      QColor c(Qt::cyan);
      c.setRgb(m_pSettings->readNumEntry(SynHighRemovedRgb, c.rgb()));
      return c;
   }
   void setRemovedColor(QColor color) {
      m_pSettings->writeEntry(SynHighRemovedRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getRemovedByOtherStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighRemovedByOtherStyle, HighlightProperties::FS_BOLD);
   }
   void setRemovedByOtherStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighRemovedByOtherStyle, style);
   }
   QColor getRemovedByOtherColor() {
      QColor c(Qt::green);
      c.setRgb(m_pSettings->readNumEntry(SynHighRemovedByOtherRgb, c.rgb()));
      return c;
   }
   void setRemovedByOtherColor(QColor color) {
      m_pSettings->writeEntry(SynHighRemovedByOtherRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getDiffOldStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighDiffOldStyle, HighlightProperties::FS_NORMAL);
   }
   void setDiffOldStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighDiffOldStyle, style);
   }
   QColor getDiffOldColor() {
      QColor c(Qt::red);
      c.setRgb(m_pSettings->readNumEntry(SynHighDiffOldRgb, c.rgb()));
      return c;
   }
   void setDiffOldColor(QColor color) {
      m_pSettings->writeEntry(SynHighDiffOldRgb, (int)color.rgb());
   }
   HighlightProperties::FontStyle getDiffNewStyle() {
      return (HighlightProperties::FontStyle)m_pSettings->readNumEntry(SynHighDiffNewStyle, HighlightProperties::FS_NORMAL);
   }
   void setDiffNewStyle(HighlightProperties::FontStyle style) {
      m_pSettings->writeEntry(SynHighDiffNewStyle, style);
   }
   QColor getDiffNewColor() {
      QColor c(Qt::blue);
      c.setRgb(m_pSettings->readNumEntry(SynHighDiffNewRgb, c.rgb()));
      return c;
   }
   void setDiffNewColor(QColor color) {
      m_pSettings->writeEntry(SynHighDiffNewRgb, (int)color.rgb());
   }
   
   QString getFontGeneral() {
      return m_pSettings->readEntry(FontGeneral, "");  //empty string means default font
   }
   void setFontGeneral(const QString& font) {
      m_pSettings->writeEntry(FontGeneral, font);
   }
   QString getFontMessage() {
      return m_pSettings->readEntry(FontMessage, "");  //empty string means default font
   }
   void setFontMessage(const QString& font) {
      m_pSettings->writeEntry(FontMessage, font);
   }
   QString getFontDiff() {
      return m_pSettings->readEntry(FontDiff, "");  //empty string means default font
   }
   void setFontDiff(const QString& font) {
      m_pSettings->writeEntry(FontDiff, font);
   }

   QString getTextEncoder() {
      return m_pSettings->readEntry(TextEncoder, TextCodec::DEFAULT_CODEC);  //we should use codec for locale
   }
   void setTextEncoder(const QString& encoder) {
      m_pSettings->writeEntry(TextEncoder, encoder);
   }
   QString getTextDecoder() {
      return m_pSettings->readEntry(TextDecoder, TextCodec::DEFAULT_CODEC);  //we should use codec for locale
   }
   void setTextDecoder(const QString& decoder) {
      m_pSettings->writeEntry(TextDecoder, decoder);
   }
   
 protected:
   int geomX() {
      return m_pSettings->readNumEntry(GeomX, 50);
   }
   void setGeomX(int val) {
      m_pSettings->writeEntry(GeomX, val);
   }
   int geomY() {
      return m_pSettings->readNumEntry(GeomY, 50);
   }
   void setGeomY(int val) {
      m_pSettings->writeEntry(GeomY, val);
   }
   int geomWidth() {
      return m_pSettings->readNumEntry(GeomWidth, 400);
   }
   void setGeomWidth(int val) {
      m_pSettings->writeEntry(GeomWidth, val);
   }
   int geomHeight() {
      return m_pSettings->readNumEntry(GeomHeight, 300);
   }
   void setGeomHeight(int val) {
      m_pSettings->writeEntry(GeomHeight, val);
   }

 protected:

   QSettings* m_pSettings;

 private:
      
   void readProjectSettings( QString);
   void writeProjectSettings( QString);
   void removeProjectSettings( QString);

   void updateVersionOnRead(const QString&,const QString&);
   QString updateVersionOnWrite(const QString&,const QString&);
   void readProfiles(QStringList tmpList);

   void readExtApps();
   void writeExtApps();

   Mapping::FileAppList extractMapping(const QStringList&);
   QStringList joinMapping(const Mapping::FileAppList&);
   bool m_needUpdate;

};

//----------------------------------------------------------------------------

#endif
