/****************************************************************************
 **
 ** Copyright (C) 2001-2004 Tilo Riemer <riemer@lincvs.org> and
 **                         Frank Hemer <frank@hemer.org>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/

#include "Move.h"

#include <qapplication.h>
#include <qiconset.h>
#include <assert.h>

#include "globals.h"
#include "Remove.h"
#include "Add.h"

// Move * Move::moveFile(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench)
// {
//    return setup(whatsThisIconSet, parent, workBench, false);
// }

Move * Move::moveSelectionFile(const QIconSet &whatsThisIconSet,
      QWidget* parent,
      CvsDirListView * workBench,
      DirBase * dir,
      QStringList list,
      QObject * receiver) {
   return setup(whatsThisIconSet, parent, workBench, dir, false, list, receiver);
}

// Move * Move::setup(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, bool isDir) {

//    DirBase * dir = workBench->selectedItem();
//    if (!dir) return NULL;

//    QStringList list;
//    if (!isDir || (dir->getType() == DirBase::Cvs)) {
//       list = dir->getSelectedFiles();
//       if (list.isEmpty()) return NULL;
//    }

//    return setup(whatsThisIconSet, parent, workBench, dir, isDir, list);
// }

Move * Move::setup(const QIconSet &whatsThisIconSet,
      QWidget* parent,
      CvsDirListView * workBench,
      DirBase * dir,
      bool isDir,
      QStringList filesList,
      QObject * receiver) {

   if (dir->getType() == DirBase::Cvs) {

      Move * p = new Move(whatsThisIconSet, parent, workBench, dir, isDir);
      if (receiver) {
	 connect(p, SIGNAL(done(bool)), receiver, SLOT(callDone(bool)));
	 p->m_activate = false;
      }
      p->m_filesList = filesList;
      p->m_filesList.sort();
      p->m_mode = ANALYZE;
      p->m_staticIt = p->m_filesList.begin();
      p->acceptCvs();
      return p;
   } else {
      qDebug("Move: Method not implemented");
   }
   return NULL;
}

Move::Move(const QIconSet &whatsThisIconSet, QWidget* parent, CvsDirListView * workBench, DirBase * dir, bool isDir)
   :  m_whatsThisIconSet(whatsThisIconSet),
      m_parent(parent),
      m_workBench(workBench),
      m_dir(dir),
      m_dlg(NULL),
      m_isDir(isDir),
      m_activate(true)
{
   connect(this,SIGNAL(deleteObject(QObject *)),parent,SLOT(slot_deleteObject(QObject *)));
   connect(this,SIGNAL(checkInProgress(bool)),parent,SLOT(checkInProgress(bool)));
   connect(this,SIGNAL(showWarning(const QString&,const QString&)),parent,SLOT(showWarning(const QString&,const QString&)));
}

Move::~Move() {
   if (m_dlg) delete m_dlg;
   m_dlg = NULL;
}

void Move::acceptCvs() {

   assert(m_dir);

   while (true) {
      switch (m_mode) {
	 case ANALYZE: {
	    QStringList::Iterator it;
	    for (it = m_filesList.begin(); it != m_filesList.end(); ++it) {
	       int pos = (*it).findRev("/");
	       QString removeDir = (*it).left(pos);
	       QString fileName = (*it).mid(pos+1);
	       DirBase * tmpDir = m_workBench->find(removeDir);
	       assert(tmpDir);
	       if (!tmpDir->isBinary(fileName)) {
		  m_dropAsciiFiles.append(fileName);
	       } else {
		  m_dropBinaryFiles.append(fileName);
	       }
	    }
	    m_mode = REMOVE;
	    break;
	 }
	 case REMOVE: {
	    remove();
	    return;
	 }
	 case ADDASCII: {
	    m_mode = ADDBINARY;
	    if (!m_dropAsciiFiles.isEmpty()) {
	       Add::addSelectionAscii(m_whatsThisIconSet,m_parent,m_workBench,m_dir,m_dropAsciiFiles,this);
	       return;
	    }
	    break;
	 }
	 case ADDBINARY: {
	    m_mode = DONE;
	    if (!m_dropBinaryFiles.isEmpty()) {
	       Add::addSelectionBinary(m_whatsThisIconSet,m_parent,m_workBench,m_dir,m_dropBinaryFiles,this);
	       return;
	    }
	    break;
	 }
	 case DONE: {
	    emit checkInProgress(true);
	    m_dir->postCallCheck();
	    emit checkInProgress(false);
	    reject(true);
	    return;
	 }
	 default: {
	    assert(false);
	    break;
	 }
      }
   }
}

void Move::remove() {
   if (m_staticIt != m_filesList.end()) {
      QString removeDir = (*m_staticIt).left( (*m_staticIt).findRev("/") );
      DirBase * tmpDir = m_workBench->find(removeDir);
      assert(tmpDir);

      QStringList rmFileList;
      QStringList::ConstIterator it;
      for (it = m_staticIt; it != m_filesList.end(); ++it) {
	 int pos = (*it).findRev("/");
	 QString nextRemoveDir = (*it).left(pos);
	 if (removeDir==nextRemoveDir) {
	    QString fileName = (*it).mid(pos+1);
	    rmFileList.append(fileName);
	    m_staticIt = it;
	    ++m_staticIt;
	 } else {
	    m_staticIt = it;
	    break;
	 }
      }
      if (it == m_filesList.end()) {
	 m_mode = ADDASCII;
      }
      Remove::removeSelectionFile(m_whatsThisIconSet,m_parent,m_workBench,tmpDir,rmFileList,this);
   }
}

void Move::callDone(bool state) {
   if (state) {
      acceptCvs();
   } else {
      emit showWarning(tr("Warning"),tr("Command failed"));
      reject(false);
   }
}

void Move::reject(bool state) {
   emit done(state);
   emit deleteObject(this);
}

void Move::cvsCallStarted() {
   QApplication::setOverrideCursor(Qt::waitCursor);
}

void Move::cvsCallFinished() {
   QApplication::restoreOverrideCursor();
}

void Move::afterCall(int cmd,CvsBuffer*,bool failed) {
   cvsCallFinished();
   if (failed) {
      reject(false);
      return;
   }
   switch( cmd) {
      case NOOP: {
	 break;
      }
      default: {
	 qDebug("Move::afterCall: Unknown cmd");
      }
   }
   reject(true);
}
