/****************************************************************************
**
** Copyright (C) 2002-2004 Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** LinCVS is available under two different licenses:
**
** If LinCVS is linked against the GPLed version of Qt 
** LinCVS is released under the terms of GPL also.
**
** If LinCVS is linked against a nonGPLed version of Qt 
** LinCVS is released under the terms of the 
** LinCVS License for non-Unix platforms (LLNU)
**
**
** LinCVS License for non-Unix platforms (LLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than LinCVS.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** LinCVS License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation; either version 2 of the License, or 
** (at your  option) any later version.  This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/


#include "config.h"

#include <qlistview.h>
#include <qwhatsthis.h>
#include <qpushbutton.h>
#include <qregexp.h>
#include <qlayout.h>
#include <qsizegrip.h>

#ifndef Q_WS_WIN
#include <unistd.h>
#endif

#include "globals.h"
#include "WatchersDialogImpl.h"

/* 
 *  Constructs a WatchersDialogImpl which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
WatchersDialogImpl::WatchersDialogImpl(const QIconSet &whatsThisIconSet,
				       QWidget* parent, 
				       const char* name, WFlags fl )
    : WatchersDialog( LookAndFeel::g_b0AsParent ? 0 : parent, name, fl )
{
  m_pWhatsThis->setIconSet(whatsThisIconSet);
#ifdef Q_WS_MAC
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height() * 2);
#else
  m_pWhatsThis->setMaximumWidth(m_pWhatsThis->height());
#endif
  ButtonLayout->addWidget(new QSizeGrip(this),0,Qt::AlignRight|Qt::AlignBottom);

  WatchersList->setColumnAlignment(2,Qt::AlignHCenter);
  WatchersList->setColumnAlignment(3,Qt::AlignHCenter);
  WatchersList->setColumnAlignment(4,Qt::AlignHCenter);
  WatchersList->setColumnAlignment(5,Qt::AlignHCenter);
  WatchersList->setColumnAlignment(6,Qt::AlignHCenter);
  WatchersList->setColumnAlignment(7,Qt::AlignHCenter);

  connect(WatchersList, SIGNAL(doubleClicked(QListViewItem *)), this, SLOT(viewFile(QListViewItem *)) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
WatchersDialogImpl::~WatchersDialogImpl()
{
    // no need to delete child widgets, Qt does it all for us
}

void WatchersDialogImpl::parseWatchers(CvsBuffer *output, QString)
{
  unsigned int len = (*output).numLines();
  QString line;

  int pos;
  QString file;
  QString user;
  int skiplines = outputLineOffset + 1;//skip first line

  for (unsigned int i = skiplines; i<len;i++) {
    line = (*output).textLine(i);
    if (line.isEmpty() || line.startsWith("?")) continue;
    QString tmp = line;
    QListViewItem *item = new QListViewItem (WatchersList);

    if (line.startsWith("\t")) {
      pos = 1;
    } else {
      pos = line.find("\t");
      file = line.left(pos++);
    }

    user = line.mid(pos,line.find("\t",pos)-pos);

    line = line.mid(pos);

    pos = line.findRev(QRegExp("\\btcommit\\b"));
    if (pos > -1) {
	item->setText(7,"X");
	line = line.remove(pos-1,8);
    }

    pos = line.findRev(QRegExp("\\btunedit\\b"));
    if (pos > -1) {
	item->setText(6,"X");
	line = line.remove(pos-1,8);
    }

    pos = line.findRev(QRegExp("\\btedit\\b"));
    if (pos > -1) {
	item->setText(5,"X");
	line = line.remove(pos-1,6);
    }

    pos = line.findRev(QRegExp("\\bcommit\\b"));
    if (pos > -1) {
        item->setText(4,"X");
	line = line.remove(pos-1,7);
    }

    pos = line.findRev(QRegExp("\\bunedit\\b"));
    if (pos > -1) {
	item->setText(3,"X");
	line = line.remove(pos-1,7);
    }

    pos = line.findRev(QRegExp("\\bedit\\b"));
    if (pos > -1) {
	item->setText(2,"X");
	line = line.remove(pos-1,5);
    }

    item->setText(0,file);
    item->setText(1,user);
  }

}

void WatchersDialogImpl::viewFile(QListViewItem *) {

}

void WatchersDialogImpl::enterWhatsThisMode()
{
   QWhatsThis::enterWhatsThisMode();
}
