#include "operl.h"

static int _lvl = 0;
static int _lvl_type[256];

int DEF_(char *name, const char *format, ...) {
	va_list argp;
	INDENT;
	printf("%s => ", name);
	
	va_start(argp, format);
	vprintf(format, argp);
	va_end(argp);
	printf(",\n");
}

int HASH_(char *name) {
	INDENT;
	if (name) {
		printf((_lvl ? "%s => {\n" : "our %%%s = (\n"), name);
	} else {
		printf("{\n");
	}
	_lvl++; _lvl_type[_lvl] = 0;
}

int ARRAY_(char *name) {
	INDENT;
	printf(_lvl ? "%s => [\n" : "our @%s = (\n", name);
	_lvl_type[_lvl] = 1; _lvl++;
}

int ADEF_(const char *format, ...) {
	va_list argp;
	INDENT;
	va_start(argp, format);
	vprintf(format, argp);
	va_end(argp);
	printf(",\n");
}

void RETURN_()  {
	{ _lvl--; INDENT;
		printf("%s\n", _lvl ? (_lvl_type[_lvl] ? "]," : "},") : ");");
	}
}

void START_() {
	HASH("lsdvd");
}

void STOP_() {
	while(_lvl) RETURN;
}


void operl_print(struct dvd_info *dvd_info) {
	int j, i;

	START;
	DEF("device", "'%s'", dvd_info->discinfo.device);
	DEF("title", "'%s'", dvd_info->discinfo.disc_title);
	DEF("vmg_id", "'%.12s'", dvd_info->discinfo.vmg_id);
	DEF("provider_id", "'%.32s'", dvd_info->discinfo.provider_id);

	ARRAY("track");

	for (j=0; j < dvd_info->title_count; j++)
	{
	if ( opt_t == j+1 || opt_t == 0 ) {

	// GENERAL
	if (dvd_info->titles[j].enabled) {

		HASH(0);
		DEF("ix", "%d", j+1);
		DEF("length", "%.3f", dvd_info->titles[j].general.length);
		DEF("vts_id", "'%.12s'", dvd_info->titles[j].general.vts_id);

		if (dvd_info->titles[j].parameter.format != NULL ) {
			DEF("vts", "%d", dvd_info->titles[j].parameter.vts);
			DEF("ttn", "%d", dvd_info->titles[j].parameter.ttn);
			DEF("fps", "%.2f", dvd_info->titles[j].parameter.fps);
			DEF("format", "'%s'", dvd_info->titles[j].parameter.format);
			DEF("aspect", "'%s'", dvd_info->titles[j].parameter.aspect);
			DEF("width", "%s", dvd_info->titles[j].parameter.width);
			DEF("height", "%s", dvd_info->titles[j].parameter.height);
			DEF("df", "'%s'", dvd_info->titles[j].parameter.df);
		}

		// PALETTE
		if (dvd_info->titles[j].palette != NULL) {
			ARRAY("palette");
			for (i=0; i < 16; i++) {
				ADEF("'%06x'",  dvd_info->titles[j].palette[i]);
			}
			RETURN;
		}

		// ANGLES
		if (dvd_info->titles[j].angle_count) { // poor check, but there's no other info anyway.
			DEF("angles", "%d", dvd_info->titles[j].angle_count);
		}

		// AUDIO
		if (dvd_info->titles[j].audiostreams != NULL ) {
			ARRAY("audio");
			for (i=0; i<dvd_info->titles[j].audiostream_count; i++)
			{
				HASH(0);
				DEF("ix", "%d", i+1);
				DEF("langcode", "'%s'", dvd_info->titles[j].audiostreams[i].langcode);
				DEF("language", "'%s'", dvd_info->titles[j].audiostreams[i].language);
				DEF("format", "'%s'", dvd_info->titles[j].audiostreams[i].format);
				DEF("frequency", "%s", dvd_info->titles[j].audiostreams[i].frequency);
				DEF("quantization", "'%s'", dvd_info->titles[j].audiostreams[i].quantization);
				DEF("channels", "%d", dvd_info->titles[j].audiostreams[i].channels);
				DEF("ap_mode", "%d", dvd_info->titles[j].audiostreams[i].ap_mode);
				DEF("content", "'%s'", dvd_info->titles[j].audiostreams[i].content);
				DEF("streamid", "'0x%x'", dvd_info->titles[j].audiostreams[i].streamid);
				RETURN;
			}
			RETURN; 
		}

		// CHAPTERS
		if (dvd_info->titles[j].chapters != NULL) {
			ARRAY("chapter");
			for (i=0; i<dvd_info->titles[j].chapter_count; i++)
			{
				HASH(0);
				DEF("ix", "%d", i+1);
				DEF("length", "%.3f", dvd_info->titles[j].chapters[i].length);
				DEF("startcell", "%d", dvd_info->titles[j].chapters[i].startcell);
				RETURN;
			}
			RETURN;
		}

		// CELLS
		if (dvd_info->titles[j].cells != NULL) {
			ARRAY("cell");
			for (i=0; i<dvd_info->titles[j].cell_count; i++)
			{
				HASH(0);
				DEF("ix", "%d", i+1);
				DEF("length", "%.3f", dvd_info->titles[j].cells[i].length);
				RETURN;
			}
			RETURN;
		}

		// SUBTITLES
		if (dvd_info->titles[j].subtitles != NULL) {
			ARRAY("subp");
			for (i=0; i<dvd_info->titles[j].subtitle_count; i++)
			{
				HASH(0);
				DEF("ix", "%d", i+1);
				DEF("langcode", "'%s'", dvd_info->titles[j].subtitles[i].langcode);
				DEF("language", "'%s'", dvd_info->titles[j].subtitles[i].language);
				DEF("content", "'%s'", dvd_info->titles[j].subtitles[i].content);
				DEF("streamid", "'0x%x'", dvd_info->titles[j].subtitles[i].streamid);
				RETURN;
			}
			RETURN;
		}
	RETURN;	
	}
	}
	}
	RETURN;
	if (! opt_t) {
		
//		int max_length = 0, max_track = 0;
//		for (j=0; j < dvd_info->title_count; j++) {
//			if (dvd_info->titles[j].general.length > max_length) {
//				max_length = dvd_info->titles[j].general.length;
//				max_track = j+1;
//			}
//		}
		DEF("longest_track", "%d", dvd_info->longest_track);
	}
	STOP;


}
