/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractMapDeserializer;
import com.caucho.hessian.io.IOExceptionWrapper;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class JavaDeserializer
extends AbstractMapDeserializer {
    private Class _type;
    private HashMap _fieldMap;
    private Method _readResolve;
    private Constructor _constructor;
    private Object[] _constructorArgs;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public JavaDeserializer(Class cl) {
        this._type = cl;
        this._fieldMap = this.getFieldMap(cl);
        this._readResolve = this.getReadResolve(cl);
        if (this._readResolve != null) {
            this._readResolve.setAccessible(true);
        }
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        int bestCost = Integer.MAX_VALUE;
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] param = constructors[i].getParameterTypes();
            int cost = 0;
            for (int j = 0; j < param.length; ++j) {
                cost = 10 * cost;
                if (JavaDeserializer._resin_compat_class_0().equals(param[j])) {
                    ++cost;
                    continue;
                }
                if (JavaDeserializer._resin_compat_class_1().equals(param[j])) {
                    cost += 2;
                    continue;
                }
                if (Integer.TYPE.equals(param[j])) {
                    cost += 3;
                    continue;
                }
                if (Long.TYPE.equals(param[j])) {
                    cost += 4;
                    continue;
                }
                if (param[j].isPrimitive()) {
                    cost += 5;
                    continue;
                }
                cost += 9;
            }
            if (cost >= bestCost) continue;
            this._constructor = constructors[i];
            bestCost = cost;
        }
        if (this._constructor != null) {
            this._constructor.setAccessible(true);
            Class<?>[] params = this._constructor.getParameterTypes();
            this._constructorArgs = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                this._constructorArgs[i] = JavaDeserializer.getParamArg(params[i]);
            }
        }
    }

    public Class getType() {
        return this._type;
    }

    public Object readMap(AbstractHessianInput in) throws IOException {
        try {
            Object obj = this.instantiate();
            return this.readMap(in, obj);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(new CharBuffer().append(this._type.getName()).append(":").append(e.getMessage()).toString(), e);
        }
    }

    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        try {
            Object obj = this.instantiate();
            return this.readObject(in, obj, fieldNames);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(new CharBuffer().append(this._type.getName()).append(":").append(e.getMessage()).toString(), e);
        }
    }

    protected Method getReadResolve(Class cl) {
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("readResolve") || method.getParameterTypes().length != 0) continue;
                return method;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public Object readMap(AbstractHessianInput in, Object obj) throws IOException {
        try {
            int ref = in.addRef(obj);
            while (!in.isEnd()) {
                Object key = in.readObject();
                FieldDeserializer deser = (FieldDeserializer)this._fieldMap.get(key);
                if (deser != null) {
                    deser.deserialize(in, obj);
                    continue;
                }
                in.readObject();
            }
            in.readMapEnd();
            Object resolve = this.resolve(obj);
            if (obj != resolve) {
                in.setRef(ref, resolve);
            }
            return resolve;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    public Object readObject(AbstractHessianInput in, Object obj, String[] fieldNames) throws IOException {
        try {
            int ref = in.addRef(obj);
            for (int i = 0; i < fieldNames.length; ++i) {
                String name = fieldNames[i];
                FieldDeserializer deser = (FieldDeserializer)this._fieldMap.get(name);
                if (deser != null) {
                    deser.deserialize(in, obj);
                    continue;
                }
                in.readObject();
            }
            Object resolve = this.resolve(obj);
            if (obj != resolve) {
                in.setRef(ref, resolve);
            }
            return resolve;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(new CharBuffer().append(obj.getClass().getName()).append(":").append(e).toString(), e);
        }
    }

    private Object resolve(Object obj) throws Exception {
        block3: {
            try {
                if (this._readResolve != null) {
                    return this._readResolve.invoke(obj, new Object[0]);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() == null) break block3;
                throw e;
            }
        }
        return obj;
    }

    protected Object instantiate() throws Exception {
        if (this._constructor != null) {
            return this._constructor.newInstance(this._constructorArgs);
        }
        return this._type.newInstance();
    }

    protected HashMap getFieldMap(Class cl) {
        HashMap<String, StringFieldDeserializer> fieldMap = new HashMap<String, StringFieldDeserializer>();
        while (cl != null) {
            Field[] fields = cl.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || fieldMap.get(field.getName()) != null) continue;
                try {
                    field.setAccessible(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                Class<?> type = field.getType();
                FieldDeserializer deser = JavaDeserializer._resin_compat_class_1().equals(type) ? new StringFieldDeserializer(field) : (Byte.TYPE.equals(type) ? new ByteFieldDeserializer(field) : (Short.TYPE.equals(type) ? new ShortFieldDeserializer(field) : (Integer.TYPE.equals(type) ? new IntFieldDeserializer(field) : (Long.TYPE.equals(type) ? new LongFieldDeserializer(field) : (Float.TYPE.equals(type) ? new FloatFieldDeserializer(field) : (Double.TYPE.equals(type) ? new DoubleFieldDeserializer(field) : (Boolean.TYPE.equals(type) ? new BooleanFieldDeserializer(field) : new ObjectFieldDeserializer(field))))))));
                fieldMap.put(field.getName(), (StringFieldDeserializer)deser);
            }
            cl = cl.getSuperclass();
        }
        return fieldMap;
    }

    protected static Object getParamArg(Class cl) {
        if (!cl.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(cl)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(cl)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(cl)) {
            return new Short(0);
        }
        if (Character.TYPE.equals(cl)) {
            return new Character('\u0000');
        }
        if (Integer.TYPE.equals(cl)) {
            return new Integer(0);
        }
        if (Long.TYPE.equals(cl)) {
            return new Long(0L);
        }
        if (Float.TYPE.equals(cl)) {
            return new Double(0.0);
        }
        if (Double.TYPE.equals(cl)) {
            return new Double(0.0);
        }
        throw new UnsupportedOperationException();
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class StringFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        StringFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            String value = in.readString();
            try {
                this._field.set(obj, value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class DoubleFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        DoubleFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            double value = in.readDouble();
            try {
                this._field.setDouble(obj, value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class FloatFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        FloatFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            double value = in.readDouble();
            try {
                this._field.setFloat(obj, (float)value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class LongFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        LongFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            long value = in.readLong();
            try {
                this._field.setLong(obj, value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class IntFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        IntFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = in.readInt();
            try {
                this._field.setInt(obj, value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class ShortFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        ShortFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = in.readInt();
            try {
                this._field.setShort(obj, (short)value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class ByteFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        ByteFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            int value = in.readInt();
            try {
                this._field.setByte(obj, (byte)value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class BooleanFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        BooleanFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            boolean value = in.readBoolean();
            try {
                this._field.setBoolean(obj, value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static class ObjectFieldDeserializer
    extends FieldDeserializer {
        private final Field _field;

        ObjectFieldDeserializer(Field field) {
            this._field = field;
        }

        void deserialize(AbstractHessianInput in, Object obj) throws IOException {
            Object value = in.readObject(this._field.getType());
            try {
                this._field.set(obj, value);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
    }

    static abstract class FieldDeserializer {
        FieldDeserializer() {
        }

        abstract void deserialize(AbstractHessianInput var1, Object var2) throws IOException;
    }
}

