/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.hivemind.service.ThreadCleanupListener;
import org.apache.hivemind.service.ThreadEventNotifier;
import org.apache.hivemind.service.ThreadLocalStorage;

public class ThreadLocalStorageImpl
implements ThreadLocalStorage,
ThreadCleanupListener {
    private static final String INITIALIZED_KEY = "$org.apache.hivemind.service.impl.ThreadLocalStorageImpl#initialized$";
    private CleanableThreadLocal _local = new CleanableThreadLocal();
    private ThreadEventNotifier _notifier;

    private Map getThreadLocalVariable() {
        Map map = (Map)this._local.get();
        if (Boolean.TRUE.equals(map.get(INITIALIZED_KEY)) && this._notifier != null) {
            this._notifier.addThreadCleanupListener(this);
            map.remove(INITIALIZED_KEY);
        }
        return map;
    }

    public Object get(String key) {
        Map map = this.getThreadLocalVariable();
        return map.get(key);
    }

    public void put(String key, Object value) {
        Map map = this.getThreadLocalVariable();
        map.put(key, value);
    }

    public void clear() {
        Map map = (Map)this._local.get();
        if (map != null) {
            map.clear();
        }
    }

    public void setNotifier(ThreadEventNotifier notifier) {
        this._notifier = notifier;
    }

    public void threadDidCleanup() {
        this.clear();
    }

    private static class CleanableThreadLocal
    extends ThreadLocal {
        private CleanableThreadLocal() {
        }

        protected Object initialValue() {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            map.put(ThreadLocalStorageImpl.INITIALIZED_KEY, Boolean.TRUE);
            return map;
        }
    }
}

