/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.util;

import java.util.Iterator;

public class EventListenerList {
    private static final int START_SIZE = 5;
    private Object[] _listeners;
    private int _count;
    private int _iteratorCount;
    private int _uid;

    public synchronized Iterator getListeners() {
        ++this._iteratorCount;
        return new ListenerIterator();
    }

    public synchronized void addListener(Object listener) {
        this.copyOnWrite(this._count + 1);
        this._listeners[this._count] = listener;
        ++this._count;
    }

    public synchronized void removeListener(Object listener) {
        for (int i = 0; i < this._count; ++i) {
            if (this._listeners[i] != listener) continue;
            this.removeListener(i);
            return;
        }
    }

    private void removeListener(int index) {
        this.copyOnWrite(this._count);
        this._listeners[index] = this._listeners[this._count - 1];
        this._listeners[this._count - 1] = null;
        --this._count;
    }

    private void copyOnWrite(int requiredSize) {
        int size;
        int n = size = this._listeners == null ? 0 : this._listeners.length;
        if (this._iteratorCount > 0 || size < requiredSize) {
            int nominalSize;
            int n2 = nominalSize = size == 0 ? 5 : 2 * size;
            if (size >= requiredSize) {
                nominalSize = size;
            }
            int newSize = Math.max(requiredSize, nominalSize);
            Object[] newListeners = new Object[newSize];
            if (this._count > 0) {
                System.arraycopy(this._listeners, 0, newListeners, 0, this._count);
            }
            this._listeners = newListeners;
            this._iteratorCount = 0;
            ++this._uid;
        }
    }

    private synchronized void adjustIteratorCount(int iteratorUid) {
        if (this._uid == iteratorUid) {
            --this._iteratorCount;
        }
    }

    private class ListenerIterator
    implements Iterator {
        private Object[] _localListeners;
        private int _localCount;
        private int _localUid;
        private int _pos;

        private ListenerIterator() {
            this._localListeners = EventListenerList.this._listeners;
            this._localCount = EventListenerList.this._count;
            this._localUid = EventListenerList.this._uid;
        }

        public boolean hasNext() {
            if (this._pos >= this._localCount) {
                EventListenerList.this.adjustIteratorCount(this._localUid);
                this._localListeners = null;
                this._localCount = 0;
                this._localUid = -1;
                this._pos = 0;
                return false;
            }
            return true;
        }

        public Object next() {
            return this._localListeners[this._pos++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

