/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.OperationStatus;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet
extends StoredCollection
implements Set {
    StoredEntrySet(DataView dataView) {
        super(dataView);
    }

    public boolean add(Object object) {
        Map.Entry entry = (Map.Entry)object;
        return this.add(entry.getKey(), entry.getValue());
    }

    public boolean remove(Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        boolean bl = this.beginAutoCommit();
        try {
            dataCursor = new DataCursor(this.view, true);
            OperationStatus operationStatus = dataCursor.getSearchBoth(entry.getKey(), entry.getValue(), true);
            if (operationStatus == OperationStatus.SUCCESS) {
                dataCursor.delete();
            }
            this.closeCursor(dataCursor);
            this.commitAutoCommit(bl);
            return operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            this.closeCursor(dataCursor);
            throw this.handleException(exception, bl);
        }
    }

    public boolean contains(Object object) {
        boolean bl;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)object;
        DataCursor dataCursor = null;
        try {
            dataCursor = new DataCursor(this.view, false);
            OperationStatus operationStatus = dataCursor.getSearchBoth(entry.getKey(), entry.getValue(), false);
            bl = operationStatus == OperationStatus.SUCCESS;
        }
        catch (Exception exception) {
            try {
                throw StoredContainer.convertException(exception);
            }
            catch (Throwable throwable) {
                this.closeCursor(dataCursor);
                throw throwable;
            }
        }
        this.closeCursor(dataCursor);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = this.iterator();
        try {
            Object object;
            while (iterator.hasNext()) {
                object = (Map.Entry)iterator.next();
                if (stringBuffer.length() > 1) {
                    stringBuffer.append(',');
                }
                Object k = object.getKey();
                Object v = object.getValue();
                if (k != null) {
                    stringBuffer.append(k.toString());
                }
                stringBuffer.append('=');
                if (v == null) continue;
                stringBuffer.append(v.toString());
            }
            stringBuffer.append(']');
            object = stringBuffer.toString();
            return object;
        }
        finally {
            StoredIterator.close(iterator);
        }
    }

    Object makeIteratorData(StoredIterator storedIterator, DataCursor dataCursor) throws DatabaseException {
        return new StoredMapEntry(dataCursor.getCurrentKey(), dataCursor.getCurrentValue(), this, storedIterator);
    }

    boolean hasValues() {
        return true;
    }
}

