#!/bin/sh

if [ $# -gt 0 ]; then
    import_code=$1
fi

lw_dir=/usr/lib/lispworks43

if [ "$2" ]; then
# This is the original distributed file. All downloaded patches
# will automatically be loaded by the make-images.lisp file
    lw_exe=lispworks-4300  
else
# Build an image from the current system image rather than the original
# distributed image
    lw_exe=lw-console
fi

rm -f $lw_dir/lw-console.new $lw_dir/lw-gui.new

CLC_IMPORT_FILE="$import_code" $lw_dir/$lw_exe -siteinit - -init $lw_dir/make-images.lisp > /dev/null || exit 1

if [ -f $lw_dir/lw-console.new ]; then
    rm $lw_dir/lw-console
    mv $lw_dir/lw-console.new $lw_dir/lw-console
fi

if [ -f $lw_dir/lw-gui.new ]; then
    rm -f $lw_dir/lw-gui
    mv $lw_dir/lw-gui.new $lw_dir/lw-gui
fi

