/*
    libfame - Fast Assembly MPEG Encoder Library
    Copyright (C) 2000-2001 Vivien Chappelier

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/**************** prescale and postscale factors for AA&N  DCT/iDCT **********/

/* For float AA&N IDCT method, divisors are equal to quantization
 * coefficients scaled by scalefactor[row]*scalefactor[col], where
 *   scalefactor[0] = 1
 *   scalefactor[k] = cos(k*PI/16) * sqrt(2)    for k=1..7
 * We apply a further scale factor of 8.
 * What's actually stored is 1/divisor so that the inner loop can
 * use a multiplication rather than a division.
 */

/* Postscale coefficients */
/* postscale[i][j] = 1/(8*scalefactor[i]*scalefactor[j]) */
FAME_ALIGNED static float const postscale[64] = {
  0.125000, 0.090120, 0.095671, 0.106304,
  0.125000, 0.159095, 0.230970, 0.453064,
  0.090120, 0.064973, 0.068975, 0.076641,
  0.090120, 0.114701, 0.166520, 0.326641,
  0.095671, 0.068975, 0.073223, 0.081361,
  0.095671, 0.121766, 0.176777, 0.346760,
  0.106304, 0.076641, 0.081361, 0.090404,
  0.106304, 0.135299, 0.196424, 0.385299,
  0.125000, 0.090120, 0.095671, 0.106304,
  0.125000, 0.159095, 0.230970, 0.453064,
  0.159095, 0.114701, 0.121766, 0.135299,
  0.159095, 0.202489, 0.293969, 0.576641,
  0.230970, 0.166520, 0.176777, 0.196424,
  0.230970, 0.293969, 0.426777, 0.837153,
  0.453064, 0.326641, 0.346760, 0.385299,
  0.453064, 0.576641, 0.837153, 1.642134
};

/* Prescale coefficients */
/* prescale[i][j] = scalefactor[i]*scalefactor[j]/8 */
FAME_ALIGNED static float const prescale[64] = {
  0.125000000, 0.173379981, 0.163320371, 0.146984450,
  0.125000000, 0.098211870, 0.067649512, 0.034487422,
  0.173379981, 0.240484941, 0.226531862, 0.203873289,
  0.173379981, 0.136223777, 0.093832569, 0.047835429, 
  0.163320371, 0.226531862, 0.213388348, 0.192044439,
  0.163320371, 0.128319992, 0.088388348, 0.045059989, 
  0.146984450, 0.203873289, 0.192044439, 0.172835429,
  0.146984450, 0.115484941, 0.079547411, 0.040552919, 
  0.125000000, 0.173379981, 0.163320371, 0.146984450,
  0.125000000, 0.098211870, 0.067649512, 0.034487422, 
  0.098211870, 0.136223777, 0.128319992, 0.115484941,
  0.098211870, 0.077164571, 0.053151881, 0.027096594, 
  0.067649512, 0.093832569, 0.088388348, 0.079547411,
  0.067649512, 0.053151881, 0.036611652, 0.018664458, 
  0.034487422, 0.047835429, 0.045059989, 0.040552919,
  0.034487422, 0.027096594, 0.018664458, 0.009515058 
};
