/* DefaultGraphModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin;


/**
 * Default implementation of {@link MutableGraphModel}.
 */
public class DefaultGraphModel extends DefaultGraph implements MutableGraphModel {
    
    //
    private GraphModelSupport support;
    
    // extends DefaultGraph
    public Vertex addNewVertex (Object annotation) {
        Vertex v = super.addNewVertex (annotation);
        support.fireVertexAdded (v);
        return v;
    }
    
    // extends DefaultGraph
    public Edge addNewEdge (Vertex firstEndpoint, Vertex secondEndpoint, Object annotation) {
        Edge e = super.addNewEdge (firstEndpoint, secondEndpoint, annotation);
        support.fireEdgeAdded (e);
        return e;
    }
    
    // extends DefaultGraph
    public void restore (Vertex v) {
        super.restore (v);
        support.fireVertexRestored(v);
    }
    
    // extends DefaultGraph
    protected void finalizeRemoveVertex(Vertex v){
        super.finalizeRemoveVertex (v);
        support.fireVertexRemoved (v);
    }
    
    // extends DefaultGraph
    protected void finalizeRemoveEdge (Edge e) {
        // super.finalizeRemoveEdge (e); // does nothing
        support.fireEdgeRemoved (e);
    }
    
    // extends DefaultGraph
    public void restore (Edge e) {
        super.restore (e);
        support.fireEdgeRestored(e);
    }
        
    // implements Graph
    public void change (Vertex vertex, Object annotation) {
        if (annotation == null) {
            if (vertex.getAnnotation () == null)
                return ;
        } else {
            if (annotation.equals (vertex.getAnnotation ()))
                return ;
        }
        super.change (vertex, annotation);
        support.fireVertexChanged (vertex);
    }
    
    // implements Graph
    public void change (Edge edge, Object annotation) {
        if (annotation == null) {
            if (edge.getAnnotation () == null)
                return ;
        } else {
            if (annotation.equals (edge.getAnnotation ()))
                return ;
        }
        super.change (edge, annotation);
        support.fireEdgeChanged (edge);
    }
    
    // extends DefaultGraph
    public void clear () {
        if (getNumberOfVertices () > 0) {
            super.clear ();
            support.fireGraphChanged ();
        }
    }
    
    /**
     * Create a new graph model for an empty graph.
     */
    public DefaultGraphModel () {
        super ();
        this.support = new GraphModelSupport ();
    }
    
    // implements GraphModel
    public void removeGraphListener (GraphListener l) {
        support.removeGraphListener (l);
    }
    
    // implements GraphModel
    public void addGraphListener (GraphListener l) {
        support.addGraphListener (l);
    }
    
    // extends DefaultGraph
    @Override public void copy (GraphView original) {
        if (this != original) {
            super.copy (original);
            support.fireGraphChanged ();
        }
    }

}
