/* Edge.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin;

/**
 * Represents a single (possibly directed) edge in a graph. Every edge
 * has two vertices as endpoints, called 'first' and 'second' endpoint.
 * The order of these vertices is immaterial when the graph is undirected.<p>
 * When an edge belongs to a graph, also its endpoints should be
 * vertices of that graph.<p>
 */
public final class Edge extends Element {
    
    // IMPORTANT: hash codes of edges should not depend on annotations

    /**
     * Create a new edge with given endpoints. <p>
     * @param firstEndpoint First end point of the Edge
     * @param secondEndpoint Second end point of the Edge
     * @param annotation Annotation for this edge, or {@code null}
     */
    Edge(Vertex firstEndpoint, Vertex secondEndpoint, Object annotation) {
        this.firstEndpoint = firstEndpoint;
        this.secondEndpoint = secondEndpoint;
        setAnnotation (annotation);
    }
    
    // bean property
    private Vertex firstEndpoint;
    
    /**
     * The first endpoint vertex of this edge.
     * @return The first endpoint of this edge
     */
    public Vertex getFirstEndpoint() {
        return firstEndpoint;
    }
    
    /**
     * Change or set the first endpoint of this edge.
     * @param firstEndpoint First endpoint for this edge.
     */
    void setFirstEndpoint(Vertex firstEndpoint) {
        this.firstEndpoint = firstEndpoint;
    }
    
    // bean property
    private Vertex secondEndpoint;
    
    /**
     * The second endpoint vertex of this edge.
     * @return The second endpoint of this edge
     */
    public Vertex getSecondEndpoint() {
        return secondEndpoint;
    }
    
    /**
     * Change or set the second endpoint of this edge.
     * @param secondEndpoint Second endpoint for this edge.
     */
    void setSecondEndpoint(Vertex secondEndpoint) {
        this.secondEndpoint = secondEndpoint;
    }
}
