/* Embedding.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin;

/**
 * A mutable version of {@link EmbeddingView}.
 */
public interface Embedding extends EmbeddingView {
    
    // public Graph getPeer ();
    // [kc] there is no reason for this to return a Graph instead 
    //      of a GraphView (as with EmbeddingView).
    
    /**
     * Set the dimension of the embedding. If this new dimension is different
     * from the current dimension then coordinates
     * of embedded vertices should be reasigned to conform to this new value.
     */
    public void setDimension (int dimension);
    
    
   /**
    * Sets the coordinates to the given values.
    * @param vertex Vertex (of the peer) whose coordinates should be changed
    * @param coordinates Array of coordinates which must be copied.
    * @throws IllegalArgumentException when the number of coordinates does not
    * agree with the dimension of the embedding.
    */
    public void setCoordinates (Vertex vertex, double[] coordinates);
    
    /**
     * Make this embedding a copy of the given view using the peer of the original.
     */
    public void copy (EmbeddingView original);

    /**
     * Make this embedding a copy of the given view using the given peer. This peer
     * is supposed to be a copy of the peer in the sense of method
     * {@link Graph#copy}.
     */
    public void copy (EmbeddingView original, GraphView newPeer);
}
