/* Vertex.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin;

/**
 * Represents a single vertex in a graph. A given vertex can belong to at most one graph
 * at the same time.<p>
 * It is allowed for vertices to 'survive' after having been 
 * removed from a graph. Typically, such <i>zombie</i> vertices are kept in memory so that
 * the undo/redo-manager may still restore it to the graph at a later time.
 * @see DefaultGraphModel
 */
public class Vertex extends Element {
    
    
    // IMPORTANT: hash codes of vertices should not depend on 
    // indices or annotations

    //
    int index;
    
    /**
     * Return the current index of this vertex. This index represents a sequence
     * number in the set of vertices of the graph to which this vertex belongs.
     * The index lies in the range 0..n-1, where n denotes the total number of vertices
     * of the graph.<p>
     * The index of a vertex may change when other vertices
     * are removed from its parent graph. A vertex which is itself removed from its graph
     * keeps its index.<p>
     */
    public int getIndex () {
        return this.index;
    }
    
    /**
     * Create a new vertex with the given annotation and index.
     */
    Vertex (Object annotation, int index) {
        super ();
        this.index = index;
        setAnnotation (annotation);
    }
    
}
