/* LabeledBinaryTree.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.engine.apengine;

import org.grinvin.engine.apengine.Operators.Operator;
import org.grinvin.engine.apengine.Operators.UnaryOperator;

/**
 * A binary tree that can be labeled.
 */
public class LabeledBinaryTree extends BinaryTree {
    
    //
    public Operator[] operators;

    public LabeledBinaryTree(int unaryOperators, int binaryOperators) {
         super(unaryOperators, binaryOperators);
         operators = new Operator[(unaryOperators + (2 * binaryOperators) + 1) * 2];
    }
    
    private LabeledBinaryTree(int[] newcontents, int firstfreeposition, int unaryCount, int binaryCount, Operator[] newoperators ) {
        super(newcontents, firstfreeposition, unaryCount, binaryCount);
        operators = new Operator[newoperators.length];
        System.arraycopy(newoperators, 0, operators, 0, newoperators.length);
    }
    
    //
    public LabeledBinaryTree clone() {
        return new LabeledBinaryTree(contents, firstfreepos, unaryCount, binaryCount, operators);
    }

    //
    protected String toString(int parent) {
        if (operators[parent] != null) {
            String[] args = new String[childCount(parent)];
            int[] children = children(parent);
            for (int i=0; i < childCount(parent); i++) {
                args[i] = toString(children[i]);
            }
            return "(" + operators[parent].renderString(args) + ")";
        } else { // unlabeled node
            return super.toString(parent);
        }
    }

    
    /**
     * Label the node at position {@code pos} with {@link Operator} {@code op}.
     */
    public final void labelNode(int pos, Operator op) {
        operators[pos] = op;
    }
    
}
