/* AbstractFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories;

import org.grinvin.params.ParameterList;


public class AbstractFactory {
    
    //
    protected ParameterList list;
    
    //
    protected Object[] values;
    
    //
    protected String[] valueStrings;
    
    // implements Factory
    public void setParameterValues(Object[] values) throws FactoryParameterException {
        checkParameters(values);
        this.values = values;
        this.valueStrings = list.toText(values);
    }
    
    // implements Factory
    public Object[] getParameterValues() {
        return values;
    }
    
    // implements Factory
    public ParameterList getParameters() {
        return this.list;
    }
    
    /**
     * Check whether all parameters were properly initialized. Can
     * be overridden by client. This implementation simply checks
     * whether all parameters have been given a value.
     * @throws FactoryParameterException when the parameters were not
     * properly initialized or invalid.
     */
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        if (values == null || values.length != list.getCount())
            throw new FactoryParameterException("Wrong number of parameter values");
        for (Object value: values)
            if (value == null)
                throw new FactoryParameterException("Parameter value not initialized");
    }
    
    /**
     * Convert the current parameters to a 'query' string, which is usually
     * used as a suffix of an identifier or URI for the object created
     * by this factory.
     */
    public String getParametersAsString() {
        int count = values.length;
        String result = "";
        if (count > 0) {
            result += "?" + list.getParameter(0).getName() + "=" + valueStrings[0];
            for (int i=1; i < count; i++)
                result += "&" + list.getParameter(i).getName() + "=" + valueStrings[i];
        }
        return result;
    }
    
}
