/* AnnotatedInvariantListComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphbrowser;

import java.awt.CardLayout;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingConstants;
import javax.swing.event.ListDataEvent;

import org.grinvin.list.InvariantList;
import org.grinvin.list.InvariantListModel;
import org.grinvin.list.InvariantListModelListener;

/**
 *
 * @author adpeeter
 */
public class AnnotatedInvariantListComponent extends JPanel implements HasInvariantList, InvariantListModelListener {
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.graphbrowser.resources");
    
    //
    private InvariantListComponent invariantList;
    
    //
    private CardLayout layout;

    
    /** Creates a new instance of AnnotatedInvariantListComponent */
    public AnnotatedInvariantListComponent(InvariantListModel model) {
        setTransferHandler(InvariantListComponent.TRANSFER_HANDLER);
        
        layout = new CardLayout();
        setLayout(layout);
        
        invariantList = new InvariantListComponent(model);
        JLabel label = new JLabel(BUNDLE.getString("InvariantList.emptytext"), SwingConstants.CENTER);
        
        add(invariantList, "graphTable");
        add(label, "label");
        
        showActiveCard();
        
        model.addInvariantListModelListener(this);

    }
    
    //
    public InvariantList getInvariantList() {
        return invariantList.getInvariantList();
    }
    
    //
    private void showActiveCard() {
        if (getInvariantList().size() < 1) {
            layout.show(this, "label");
        } else {
            layout.show(this, "graphTable");
        }
    }
    
    //
    public void intervalAdded(ListDataEvent e) {
        showActiveCard();
    }
    
    //
    public void intervalRemoved(ListDataEvent e) {
        showActiveCard();
    }
    
    //
    public void contentsChanged(ListDataEvent e) {
        showActiveCard();
    }

    
}
