/* AnnotatedScrollableGraphTableComponent.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphbrowser;

import java.awt.CardLayout;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.event.ListDataEvent;

import org.grinvin.list.GraphInvariantListModel;
import org.grinvin.list.GraphList;
import org.grinvin.list.GraphListModel;
import org.grinvin.list.GraphListModelListener;

/**
 * An annotated version of {@link ScrollableGraphTableComponent}.
 */
public class AnnotatedScrollableGraphTableComponent extends JPanel implements HasGraphList, GraphListModelListener {
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.graphbrowser.resources");
    
    //
    private ScrollableGraphTableComponent graphTable;
    
    //
    private CardLayout layout;
    
    //
    public AnnotatedScrollableGraphTableComponent(GraphInvariantListModel model, ListSelectionModel selectionModel) {
        setTransferHandler(CommonGraphListTransferHandler.TRANSFER_HANDLER);
        
        layout = new CardLayout();
        setLayout(layout);
        
        graphTable = new ScrollableGraphTableComponent(model, selectionModel);
        JLabel label = new JLabel(BUNDLE.getString("GraphList.emptytext"), SwingConstants.CENTER);
        
        add(graphTable, "graphTable");
        add(label, "label");
        
        showActiveCard();
        
        model.getGraphListModel().addGraphListModelListener(this);
    }

    //
    public GraphList getGraphList() {
        return graphTable.getGraphList();
    }
    
    //
    private void showActiveCard() {
        if (getGraphList().size() < 1) {
            layout.show(this, "label");
        } else {
            layout.show(this, "graphTable");
        }
    }
    
    //
    public void intervalAdded(ListDataEvent e) {
        showActiveCard();
    }
    
    //
    public void intervalRemoved(ListDataEvent e) {
        showActiveCard();
    }
    
    //
    public void contentsChanged(ListDataEvent e) {
        showActiveCard();
    }
    
    public void graphListModelNameChanged(GraphListModel graphListModel) {
        //ignore
    }
    
}
