/* GraphCellListPanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.graphbrowser;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;

import org.grinvin.list.GraphListModel;
import org.grinvin.preferences.GrinvinPreferences;
import org.grinvin.preferences.GrinvinPreferences.Preference;

/**
 * Panel that contains a {@link GraphCellListComponent}.
 */
public class GraphCellListPanel extends JPanel implements GraphBrowserPanel {
    
    //
    private AnnotatedGraphCellListComponent graphcelllist;
    
    /** Creates a new instance of GraphCellListPanel */
    public GraphCellListPanel(GraphListModel model, ListSelectionModel selectionModel) {
        super(new BorderLayout());
        int graphIconWidth = GrinvinPreferences.INSTANCE.getIntPreference(Preference.GRAPHICON_WIDTH);
        int graphIconHeigth = GrinvinPreferences.INSTANCE.getIntPreference(Preference.GRAPHICON_HEIGHT);
        graphcelllist = new AnnotatedGraphCellListComponent(model, selectionModel, graphIconWidth, graphIconHeigth, 4); //TODO: hardcodes sizes?
        this.add(new JScrollPane(graphcelllist));
    }
    
}
