/* CloseGraphBrowserWindow.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/*
 * CloseWindow.java
 *
 * Created on March 21, 2007, 5:57 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package org.grinvin.graphbrowser.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import org.grinvin.graphbrowser.GraphBrowserWindow;
import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;

/**
 *
 * @author adpeeter
 */
public class CloseGraphBrowserWindow extends ActionCommand {
    
    //
    private static final String KEY = GraphBrowserWindow.class.getName();
    
    /**
     * Window onto which this command acts.
     */
    private GraphBrowserWindow window;    
    
    /**
     * Construct an action command of this type.
     * @param manager Command manager, which must be of class {@link AttributedCommandManager}
     */
    public CloseGraphBrowserWindow(CommandManager manager, String id) {
        super(manager, id);
        this.window = (GraphBrowserWindow)((AttributedCommandManager)manager).getAttribute(KEY);
    }
    
    // implements handleExecute
    public void handleExecute() {
        // hide this window
        window.setVisible(false);
    }
    
}
