/* GraphEditor3D.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;
import be.ugent.caagt.swirl.mouse.MouseTool;
import be.ugent.caagt.swirl.mouse.MouseToolCommand;
import java.awt.BorderLayout;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import org.grinvin.EmbeddingModel;
import org.grinvin.MutableGraphModel;
import org.grinvin.gred.mouse.RollOverOverlay;
import org.grinvin.gred.mouse.Rotate3D;
import org.grinvin.gred.mouse.SelectElements;
import org.grinvin.gred.mouse.SelectRectangle;
import org.grinvin.gred.transformations.OrthogonalProjection;
import org.grinvin.render.DefaultRenderer;
import org.grinvin.render.Renderer;
import org.pietschy.command.LoadException;
/**
 * Graph editor window for three-dimensional embeddings
 */
public class GraphEditor3D extends JFrame {
    
    //
    private ResourceBundle rbundle;
    
    //
    private GraphBundleWithModels bundle;
    
    //
    private GraphContext context;
    
    //
    private GraphPanel3D panel;
    
    //
    private MutableGraphModel graph;
    
    //
    private EmbeddingModel embedding;
    
    /*
    public GraphEditor3D () {
        this (new DefaultEmbeddingModel (new DefaultGraphModel(), 3),
              new GraphContext ());
    }
     */
    
    /**
     * Create an editor that uses the given embedding model and context.
     * This constructor is mainly useful when models and contexts should be
     * shared between editors. In most cases users should use the
     * no argument constructor.
     */
    public GraphEditor3D (EmbeddingModel model, GraphContext context) {
        super ();
        this.embedding = model;
        this.graph = (MutableGraphModel)model.getPeer ();
        
        this.rbundle = ResourceBundle.getBundle ("org.grinvin.gred.editor");
        setTitle (rbundle.getString ("editor3D.title"));
        
        Renderer renderer = DefaultRenderer.getInstance();
        this.context = context;
        OrthogonalProjection trans = new OrthogonalProjection ();
        trans.rotateXY (0.6, 0.6);
        this.panel = new GraphPanel3D (model, trans, renderer, context, 100);
        RollOverOverlay roo = new RollOverOverlay (panel);
        
        MouseTool rotationTool = new MouseTool ();
        rotationTool.addHandler (Rotate3D.getHandler ());
        roo.setTool (rotationTool);
        
        MouseTool selectionTool = new MouseTool ();
        //selectionTool.addHandler (MoveSelection.getHandler ());
        selectionTool.addHandler (SelectElements.getHandler ());
        selectionTool.addHandler (SelectRectangle.getHandler ());
        roo.setTool (selectionTool);
        
        AttributedCommandManager commandManager = new AttributedCommandManager ();
        commandManager.setAttribute (GraphPanel.class.getName (), panel);
        commandManager.setResourceBundle (rbundle);
        
        try {
            InputStream ins = GraphEditor.class.getResourceAsStream ("editor3d.cmds");
            commandManager.load (ins);
        } catch (LoadException lex) {
            throw new RuntimeException ("Could not initialize menus", lex);
        }
        
        MouseToolCommand selectionToolCommand
            = new MouseToolCommand (commandManager, "tool.selection", roo, selectionTool);
        selectionToolCommand.export ();
        selectionToolCommand.setSelected (true);
        new MouseToolCommand (commandManager, "tool.rotation", roo, rotationTool).export ();
        add (panel);
        
        add (commandManager.getGroup ("toolbar").createToolBar (), BorderLayout.NORTH);
        
        setJMenuBar (commandManager.getGroup ("main.menu").createMenuBar ());
        
        pack ();
        setVisible (true);
    }
    
}
