/* GraphPanel3D.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred;

import org.grinvin.EmbeddingModel;
import org.grinvin.gred.transformations.OrthogonalProjection;
import org.grinvin.render.Renderer;

/**
 * Graph panel which is backed by a 3-dimensional embedding and an
 * {@link OrthogonalProjection}. Extends {@link GraphPanel}
 * with the ability to rotate the graph in three dimensions.
 */
public class GraphPanel3D extends GraphPanel {
    
    //
    private OrthogonalProjection trans;
    
    /**
     * Default constructor.
     */
    public GraphPanel3D (EmbeddingModel originalEmbedding, OrthogonalProjection trans, 
        Renderer renderer, GraphContext context, int scale) {
        super (new TransformedEmbedding (originalEmbedding, trans), 
            renderer, context, scale);
        this.trans = trans;
    }
    
    // overrides GraphPanel
    @Override public void setEmbedding (EmbeddingModel originalEmbedding) {
        super.setEmbedding(new TransformedEmbedding (originalEmbedding, trans));
    }

    // overrides GraphPanel
    @Override public void close () {
        super.close ();
        if (embedding != null)
            ((TransformedEmbedding)embedding).close ();
    }
    
    /**
     * Rotate the coordinate system.
     * @param dx relative X-movement of the mouse
     * @param dy relative Y-movement of the mouse
     */
    public void rotate (int dx, int dy) {
        double angleX = 0.5 * Math.PI * dy / scale;
        double angleY = 0.5 * Math.PI * dx / scale;
        trans.rotateXY (angleX, angleY);
    }
}
