/* Guides.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred;

import java.awt.Graphics2D;
import javax.swing.Icon;

/**
 * A guide class can be associated to a {@link GraphPanel} to provide
 * visible guides to preferred positions for vertices, and to allow a
 * 'snap to guides' functionality.
 */
public interface Guides {
    
    /**
     * Draw guides onto the panel background.
     * @param g2 Graphics environment with origin in the center of the panel
     * @param scale Number of pixels to one unit
     * @param maxX Maximum X-value that is still in the visible region of the panel
     * @param maxY Maximum Y-value that is still in the visible region of the panel
     */
    public void paint (Graphics2D g2, double scale, double maxX, double maxY) ;
    
    /**
     * Adjust the given coordinate array to correspond with 'guide'
     * positions.
     */
    public void snap (double[] coords);
    
    /**
     * Return a small icon representing this type of graph.
     */
    public Icon getButtonIcon ();
    
}
