/* SnapshotCommand.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import java.text.MessageFormat;
import java.util.ResourceBundle;

import org.grinvin.DefaultGraphBundle;
import org.grinvin.GraphBundle;
import org.grinvin.list.GraphList;
import org.grinvin.list.GraphListElement;
import org.grinvin.list.GraphListElementManager;
import org.grinvin.util.InternationalizedProperties;

import org.pietschy.command.CommandManager;

/**
 * Action that takes a snapshot of the current graph in a panel and
 * stores it into the given graph list. Graph panel and graph list must be installed
 * as attributes to the command manager with keys
 * {@code GraphPanel.class.getName()} and {@code GraphList.class.getName()}
 */
public class SnapshotCommand extends GraphPanelCommand {
    
    //
    private GraphList graphList;
    
    //
    private int count;
    
    /**
     * Construct an action of this kind.
     */
    public SnapshotCommand(CommandManager manager, String id) {
        super(manager, id);
        this.graphList = (GraphList)((AttributedCommandManager)manager).getAttribute(GraphList.class.getName());
        this.count = 1;
    }
    
    /**
     * takes a snapshot of the current graph in a panel and
     * stores it into the given graph list.
     */
    public void handleExecute() {
        GraphBundle graphbundle = new DefaultGraphBundle();
        //TODO init with empty properties?
        InternationalizedProperties properties = new InternationalizedProperties();
        
        ResourceBundle rbundle = ResourceBundle.getBundle ("org.grinvin.gred.editor");
        String newGraphName = MessageFormat.format(rbundle.getString("newgraphname.text"), count++);
        
        properties.setProperty("graph.name", newGraphName);
        graphbundle.setProperties(properties);
        panel.fillGraphBundle(graphbundle);
        
        GraphListElement g = GraphListElementManager.getInstance().createGraphListElement(graphbundle);
        graphList.add(g);
        
        panel.setDirty(false);
    }
    
}
