/* AbstractGuides.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.guides;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import javax.swing.Icon;

import org.grinvin.gred.Guides;


/**
 * Abstract implementation of {@link Guides}. Contains common functionality for
 * Guides.
 */
public abstract class AbstractGuides implements Guides {

    
    // TODO: reuse constants in common with GridLines
    
    //
    protected static final Stroke GUIDE_STROKE = new BasicStroke (1.0f);
    
    //
    protected static final Color GUIDE_COLOR = new Color (255, 151, 151);
    
    //
    protected Icon buttonIcon;
    
    /**
     * Return an icon for a button representing this kind of guide.
     */
    public Icon getButtonIcon () {
        return buttonIcon;
    }
    
    protected AbstractGuides () {
        buttonIcon = new ButtonIcon ();
    }

    abstract public void snap (double[] coords) ;

    abstract public void paint (Graphics2D g2, double scale, double maxX, double maxY) ;

   
    //
    protected class ButtonIcon implements Icon {
        
        // implements Icon
        public void paintIcon (Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g.create ();
            g2.translate (12.0+x, 12.0+y);
            g2.setRenderingHint (RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            paint (g2, 10.0, 12.0, 12.0);
        }

        // implements Icon
        public int getIconWidth () {
            return 24;
        }

        // implements Icon
        public int getIconHeight () {
            return 24;
        }
        
    }
    
}
