/* SelectElements.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.mouse;

import be.ugent.caagt.swirl.mouse.NullMouseHandler;

import java.awt.event.MouseEvent;

import javax.swing.JComponent;
import javax.swing.SwingUtilities;

import org.grinvin.Element;
import org.grinvin.gred.GraphContext;
import org.grinvin.gred.GraphPanel;

/**
 * Mouse handler which allows changing the selection by clicking
 * on elements in a {@link GraphPanel}. Consumes all first button
 * click events on a vertex or edge.
 */
public class SelectElements extends NullMouseHandler {
    
    // create a singleton
    private SelectElements() { }
    
    //
    private static SelectElements SINGLETON = new SelectElements();
    
    /**
     * Return the singleton object of this type.
     */
    public static SelectElements getHandler() {
        return SINGLETON;
    }
    
    /**
     * Sets the selection to the current element or toggles
     * the current element when 'Control' is down.
     */
    @Override public  void doMouseClicked(JComponent parent, MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            GraphContext context = ((GraphPanel)parent).getContext();
            Element element = context.getRollOver();
            if (element != null) {
                if (mouseEvent.isControlDown()) {
                    context.toggleSelection(element);
                } else {
                    context.setSelection(element);
                }
                mouseEvent.consume();
            }
        }
    }
    
    /**
     * {@inheritDoc} This mouse handler needs a {@link GraphPanel} as parent.
     */
    @Override public boolean canHandle(JComponent parent) {
        return parent instanceof GraphPanel;
    }
    
}
