/* AbstractTransformation.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.transformations;

import org.grinvin.gred.Transformation;

/**
 * Common super class of most implementations of {@link Transformation}.
 */
public abstract class AbstractTransformation extends TransformationSupport 
    implements Transformation {

    // implements Transformation
    public abstract double[] transform(double[] src, double[] dest);
    
    /**
     * {@inheritDoc}
     * This default implementation always returns {@code false}.
     */
    public boolean isInvertible () {
        return false;
    }
    
    /**
     * {@inheritDoc}<p>
     * This implementation always raises an exception.
     */
    public void inverseTransform (double x, double y, double[] result) throws IllegalStateException {
        throw new IllegalStateException ("Transformation cannot be inverted");
    }
    
    // implements Transformation
    public abstract int getDimension ();
    
}
