/* WindowGroup.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.grinvin;

import be.ugent.caagt.swirl.lists.TypedListModel;

import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import org.grinvin.graphbrowser.GraphBrowserWindow;
import org.grinvin.grinvin.commands.ActivateWindowCommand;

import org.pietschy.command.CommandGroup;
import org.pietschy.command.CommandManager;


/**
 * Handles the dynamic list of currently available graph browser windows.
 */
public class WindowGroup extends CommandGroup implements ListDataListener {
    
    //
    private TypedListModel<GraphBrowserWindow> model;
    
    
    public WindowGroup(CommandManager manager, String id, 
            TypedListModel<GraphBrowserWindow> model) {
        super(manager, id);
        this.model = model;
        rebuildGroupContent();
        model.addListDataListener(this);
    }

    private void rebuildGroupContent() {
        reset();
        for (GraphBrowserWindow w: model) {
            add(new ActivateWindowCommand(w), false);
        }
        
        rebuildAllPopups();
        fireMembersChanged();
    }

    public void intervalAdded(ListDataEvent e) {
        rebuildGroupContent ();
    }

    public void intervalRemoved(ListDataEvent e) {
        rebuildGroupContent ();
    }

    public void contentsChanged(ListDataEvent e) {
        rebuildGroupContent ();
    }

}
