/* ImportGraphListCommand.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.grinvin.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;

import org.grinvin.graphbrowser.GraphBrowserWindow;
import org.grinvin.grinvin.GrinvinWindow;
import org.grinvin.io.Graph6Loader;
import org.grinvin.io.GraphListLoader;
import org.grinvin.list.DefaultGraphInvariantListModel;
import org.grinvin.list.GraphInvariantListModel;

import org.pietschy.command.CommandManager;
import org.pietschy.command.file.AbstractFileOpenCommand;
import org.pietschy.command.file.ExtensionFileFilter;

/**
 * Command to import a graph list from a file.
 */
public class ImportGraphListCommand extends AbstractFileOpenCommand {
    
    //
    private static final Logger LOGGER = Logger.getLogger ("org.grinvin.io");
    
    //
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("org.grinvin.grinvin.commands.resources");
    
    //
    private GrinvinWindow grinvinWindow;
    
    //
    private static final FileFilter GRAPHLIST_FILTER 
            = new ExtensionFileFilter("graphlist", BUNDLE.getString("GraphListFilter.name"));
    
    //
    private static final FileFilter G6_FILTER 
            = new ExtensionFileFilter("g6", BUNDLE.getString("Graph6Filter.name"));
    
    //
    private static final String KEY = GrinvinWindow.class.getName ();
    
    public ImportGraphListCommand(CommandManager commandManager, String id) {
        super(commandManager, id, new FileFilter[] {GRAPHLIST_FILTER, G6_FILTER});
        //TODO maybe enable MultiSelection
        this.setMultiselectionEnabled(false);
        this.grinvinWindow = (GrinvinWindow)((AttributedCommandManager)commandManager).
                getAttribute(KEY);
        // [kc] cannot yet retrieve the graph lists window at this time
        // [kc] not: this.model = grinvinWindow.getGraphListsWindow().getModel();
    }
    
    
    // implements performOpen
    public void performOpen(File[] file) {
 
        try {
            GraphInvariantListModel list = new DefaultGraphInvariantListModel ();
            if (GRAPHLIST_FILTER.accept(file[0]))
                GraphListLoader.load(list, file[0], null);
            else if (G6_FILTER.accept(file[0]))
                Graph6Loader.readFile(list, file[0]);
            else
                throw new RuntimeException("Unexpected file type: " + file[0]);
            GraphBrowserWindow window = new GraphBrowserWindow (list);
            window.setVisible (true);
            grinvinWindow.getGraphListsModel().getListModel().add (window);
        } catch (IOException e) {
            //TODO: message the user
            LOGGER.log(Level.INFO, "Failed to import graph list", e);
        }
    }
}
