/* LoadWorkspaceCommand.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.grinvin.commands;

import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import org.grinvin.workspace.Workspace;
import org.grinvin.workspace.WorkspaceException;

import org.pietschy.command.CommandManager;
import org.pietschy.command.file.AbstractFileOpenCommand;
import org.pietschy.command.file.ExtensionFileFilter;

/**
 *
 * @author adpeeter
 */
public class LoadWorkspaceCommand extends AbstractFileOpenCommand {

    //
    private static final Logger LOGGER = Logger.getLogger ("org.grinvin.io");
    
    //
    private static final ExtensionFileFilter FILTER = new ExtensionFileFilter("workspace", "*.workspace");
    
    //
    private static final ResourceBundle BUNDLE 
            = ResourceBundle.getBundle("org.grinvin.grinvin.commands.resources");
   
    public LoadWorkspaceCommand(CommandManager commandManager, String id) {
        super(commandManager, id, FILTER);
        this.setMultiselectionEnabled(false);
        getFileChooser().setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    }
    
    // implements performOpen
    public void performOpen(File[] file) {
        try {
            if (file[0].exists())
                Workspace.getInstance().load(file[0]);
            else
                throw new RuntimeException ("Directory " + file[0] + " does not exist");
        } catch (WorkspaceException ex) {
            LOGGER.log(Level.WARNING, "Failed to load workspace from " + file[0], ex);
        }
    }
    
    /**
     * Ask the user for a workspace location.
     * @return directory which holds a workspace, or null when no directory
     * could be chosen.
     */
    public static File loadNewWorkspace () {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        ExtensionFileFilter filter = 
                new ExtensionFileFilter("workspace", BUNDLE.getString ("workspace.folder"));
        chooser.setFileFilter(filter);
        
        if (chooser.showDialog(null, BUNDLE.getString("workspace.save.caption")) 
            == JFileChooser.APPROVE_OPTION) {            
            return filter.checkAndAddExtension(chooser.getSelectedFile());
        }
        return null;
    }
}
