/* MultilineToolTipUI.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui;

import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicToolTipUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.CellRendererPane;
import javax.swing.JEditorPane;
import javax.swing.JComponent;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Dimension;
import java.awt.Insets;

/**
 * UI for {@link MultilineToolTip}.
 */
class MultilineToolTipUI extends BasicToolTipUI {
    
    private static final MultilineToolTipUI sharedInstance = new MultilineToolTipUI();
    
    protected CellRendererPane rendererPane;
    
    private static JEditorPane editorPane;
    
    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }
    
    public MultilineToolTipUI() {
        super();
    }
    
    public void installUI(JComponent c) {
        super.installUI(c);
        rendererPane = new CellRendererPane();
        c.add(rendererPane);
    }
    
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.remove(rendererPane);
        rendererPane = null;
    }
    
    public void paint(Graphics g, JComponent c) {
        Dimension size = c.getSize();
        editorPane.setBackground(c.getBackground());
        rendererPane.paintComponent(g, editorPane, c, 1, 1, size.width - 1, size.height - 1, true);
    }
    
    public Dimension getPreferredSize(JComponent c) {
        Insets insets = c.getInsets();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null || tipText.trim().equals(""))
            return new Dimension(0,0);
        
        //get font info
        Font font = UIManager.getFont("ToolTip.font");
        String style = "";
        if(font!=null){
            style += "font-family: " + font.getFamily() + ";";
            style += "font-size: " + font.getSize() + ";";
            if(font.isBold())
                style += "font-weight: bold;";
            if(font.isItalic())
                style += "font-weight: italic;";
        }

        tipText = "<html><head><style><!--body{" + style + "margin: 1px;}--></style></head><body>" + tipText + "</body></html>";
        
        editorPane = new JEditorPane("text/html",tipText);
        editorPane.setEditable(false);
        JViewport vp = new JViewport();
        vp.setView(editorPane);
        rendererPane.removeAll();
        rendererPane.add(vp);
        
        int width = ((MultilineToolTip)c).getTipWidth();
        Dimension d = vp.getPreferredSize();
        if( width < d.width )
            d.width = width;
        vp.setSize(d);
        editorPane.setSize(d);
        //editorPane.setSize(editorPane.getPreferredSize());
        //d.height = editorPane.getHeight();
        d.height = editorPane.getPreferredSize().height;
        vp.setSize(d);
        d.width += (insets.left+insets.right);
        d.height += (insets.top+insets.bottom);
        return d;
    }
    
    public Dimension getMinimumSize(JComponent c) {
        return getPreferredSize(c);
    }
    
    public Dimension getMaximumSize(JComponent c) {
        return getPreferredSize(c);
    }
}


